package org.gcube.soa3.connector.common.security.impl;

import org.gcube.soa3.connector.common.security.Credentials;

/**
 * 
 * Federated credentials actually are represented by an assertion id
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class FederatedCredentials implements Credentials {

	private final String 	FEDERATED = "FED";
	private 				String assertionId;
	private String headerString;
	
	public FederatedCredentials(String assertionId) 
	{
		this.assertionId = assertionId;

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void prepareCredentials() 
	{
		this.headerString = FEDERATED+" "+this.assertionId;
	}

	/**
	 * Returns "FED"
	 */
	@Override
	public String getAuthenticationType() 
	{
		return FEDERATED;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getHeaderString() 
	{
		return headerString;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAuthenticationString() 
	{
		return this.assertionId;
	}

}
