package org.gcube.soa3.connector.common.security.impl;

import org.gcube.soa3.connector.common.security.Credentials;

import com.sun.jersey.core.util.Base64;

/**
 * 
 * Implementation of {@link Credentials} encoded in Base 64
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class Base64EncodedCredentials implements Credentials {

	private Credentials actualCredentials;
	private String headerCredentials;
	
	public Base64EncodedCredentials(Credentials actualCredentials) 
	{
		this.actualCredentials = actualCredentials;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void prepareCredentials() 
	{
		this.actualCredentials.prepareCredentials();
		
		if (this.actualCredentials.getHeaderString() != null) this.headerCredentials = this.actualCredentials.getAuthenticationType()+" "+new String (Base64.encode(this.actualCredentials.getAuthenticationString()));
		
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAuthenticationType() 
	{
		return this.actualCredentials.getAuthenticationType();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAuthenticationString() 
	{
		return this.actualCredentials.getAuthenticationString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getHeaderString() 
	{
		return this.headerCredentials;
	}

}
