package org.gcube.soa3.connector.common.security;

/**
 * 
 * Credential Manager singleton class is based on an {@link InheritableThreadLocal} internal variable storing the {@link Credentials} object. The credentials
 * stored are valid for the current thread and for all the descendants 
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class CredentialManager 
{
	private static CredentialManager instance;
	private InheritableThreadLocal<Credentials> credentials;


	private CredentialManager ()
	{
		this.credentials = new InheritableThreadLocal<Credentials>();
	}
	
	
	public static CredentialManager getInstance ()
	{
		if (instance == null) instance = new CredentialManager();
		
		return instance;
	}
	
	/**
	 * 
	 * Sets the credentials for this Thread and the descendants 
	 * 
	 * @param credentials
	 */
	public void setCredentials (Credentials credentials)
	{
		this.credentials.set(credentials);
	}
	
	/**
	 * 
	 * Gets the credentials (with {@link InheritableThreadLocal} logic)
	 * 
	 * @return the credentials
	 */
	public Credentials getCredentials ()
	{
		return this.credentials.get();
	}
	
	/**
	 * 
	 * Removes the credentials
	 * 
	 */
	public void removeCredentials ()
	{
		this.credentials.remove();
	}
	

}
