/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml;

import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.AuthorizationConstants;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.NamespaceAwareRequestCtx;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.XACMLAuthzDecisionQueryBuilder;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.XACMLRequestBuilder;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap.SoapAxisConnectionEngine;
import org.gcube.common.vomanagement.security.authorisation.utils.Utils;
import org.gcube.vomanagement.utils.ehcache.DecisionEhcacheWrapper;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.authorization.exceptions.InvalidPolicyException;
import org.globus.wsrf.security.authorization.PDP;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XACMLBasedPDP
implements PDP,
AuthorizationConstants {
    private static final long serialVersionUID = 1L;
    private GCUBELog logger = new GCUBELog((Object)this);
    private String authzServiceUrl = null;
    private boolean multiroleSupport;

    public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        this.logger.debug((Object)"initialization...");
        this.logger.debug((Object)("Chain name " + name));
        String multiroleSupportString = (String)config.getProperty(name, "multiRoleSupport");
        this.multiroleSupport = multiroleSupportString == null || !multiroleSupportString.equalsIgnoreCase("false");
        this.logger.debug((Object)("Multi role support " + this.multiroleSupport));
        String authzService = (String)config.getProperty(name, "authzXACMLServiceUrl");
        this.logger.debug((Object)("Authz service " + authzService));
        if (authzService == null || authzService.trim().equals("")) {
            this.logger.error((Object)"Authz service Url null");
            throw new InitializeException("Authz service Url null");
        }
        try {
            this.authzServiceUrl = authzService.trim();
            new URL(this.authzServiceUrl);
        }
        catch (MalformedURLException exp) {
            this.logger.error((Object)"invalid authz service Url");
            throw new InitializeException("invalid authz service Url", (Exception)exp);
        }
        this.logger.debug((Object)"initialization completed");
    }

    public Node getPolicy(Node node) throws InvalidPolicyException {
        this.logger.warn((Object)"Unable to retrieve the policy");
        return null;
    }

    public String[] getPolicyNames() {
        this.logger.warn((Object)"Unable to retrieve policy names");
        return null;
    }

    public Node setPolicy(Node node) throws InvalidPolicyException {
        this.logger.warn((Object)"Unable to set the policies");
        return null;
    }

    private String[] getRoles(String roleString) {
        this.logger.debug((Object)("Role string " + roleString));
        String[] response = null;
        if (roleString != null) {
            response = this.multiroleSupport ? roleString.split(",") : new String[]{roleString};
        } else {
            this.logger.error((Object)"Role string null!");
        }
        return response;
    }

    private Boolean checkCache(String[] roles, String action, String resource) {
        this.logger.debug((Object)"Checking the cache...");
        Boolean response = null;
        boolean exit = false;
        for (int y = 0; y < roles.length && !exit; ++y) {
            String role = roles[y];
            this.logger.debug((Object)("Checking if for " + role + " is possible to do " + action + " on " + resource));
            StringBuilder cacheStringBuilder = new StringBuilder(role);
            cacheStringBuilder.append(":").append(action).append(":").append(resource);
            String cacheString = cacheStringBuilder.toString();
            this.logger.debug((Object)"Asking the decision cache...");
            Boolean decision = DecisionEhcacheWrapper.getInstance().get(cacheString);
            if (decision != null) {
                response = decision;
                if (decision.booleanValue()) {
                    exit = true;
                }
            }
            this.logger.debug((Object)("Response = " + response));
        }
        this.logger.debug((Object)("Final cache decision is " + response));
        return response;
    }

    private boolean askToArgus(String[] roles, String action, String resource) throws AuthorizationException {
        this.logger.debug((Object)"Decision not found in the cache: asking Argus...");
        boolean responseDecision = false;
        for (int y = 0; y < roles.length && !responseDecision; ++y) {
            String role = roles[y];
            this.logger.debug((Object)("Asking to Argus for role " + role));
            StringBuilder cacheStringBuilder = new StringBuilder(role);
            cacheStringBuilder.append(":").append(action).append(":").append(resource);
            String cacheString = cacheStringBuilder.toString();
            XACMLRequestBuilder requestBuilder = new XACMLRequestBuilder();
            requestBuilder.setAction(action);
            requestBuilder.setResource(resource);
            requestBuilder.setRole(role);
            try {
                this.logger.debug((Object)"Generating request context");
                NamespaceAwareRequestCtx requestContext = requestBuilder.generateRequest();
                this.logger.debug((Object)"Request context generated");
                XACMLAuthzDecisionQueryBuilder authzDecisionQueryBuilder = new XACMLAuthzDecisionQueryBuilder();
                this.logger.debug((Object)"Decision quesry builder with default values generated");
                Document requestBodyDocument = authzDecisionQueryBuilder.generateAuthzQuery(requestContext);
                this.logger.debug((Object)"Request document generated");
                this.logger.debug((Object)Utils.document2String(requestBodyDocument));
                this.logger.debug((Object)"Opening connection manager...");
                SoapAxisConnectionEngine connection = new SoapAxisConnectionEngine();
                connection.setTargetUrl(this.authzServiceUrl);
                connection.setBodyDocument(requestBodyDocument);
                this.logger.debug((Object)"Sending message...");
                ResponseCtx response = connection.sendMessage();
                this.logger.debug((Object)"Response received");
                if (response.getResults().isEmpty()) {
                    this.logger.error((Object)"No result received!!!");
                    continue;
                }
                Result resultObject = (Result)response.getResults().iterator().next();
                int decisionCode = resultObject.getDecision();
                if (decisionCode == 0) {
                    this.logger.debug((Object)"Operation allowed");
                    responseDecision = true;
                } else {
                    this.logger.debug((Object)"Operation not allowed");
                    this.logger.debug((Object)("Decision code = " + decisionCode));
                }
                this.logger.debug((Object)"Inserting result in the cache");
                DecisionEhcacheWrapper.getInstance().put(cacheString, responseDecision);
                this.logger.debug((Object)"Result inserted");
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception in generating and sending XACML request", (Throwable)e);
                throw new AuthorizationException(e.getCause().toString());
            }
        }
        return responseDecision;
    }

    public boolean isPermitted(Subject peerSubject, MessageContext context, QName op) throws AuthorizationException {
        String resource;
        this.logger.debug((Object)"checking authorizations");
        boolean result = false;
        String[] roles = this.getRoles((String)context.getProperty("Role_value"));
        if (roles == null) {
            throw new AuthorizationException("No roles found in the request!!!");
        }
        String action = (String)context.getProperty("Action_attr");
        Boolean decision = this.checkCache(roles, action, resource = (String)context.getProperty("Resource_attr"));
        if (decision != null) {
            this.logger.debug((Object)"Decision found in the cache!");
            result = decision;
        } else {
            result = this.askToArgus(roles, action, resource);
        }
        return result;
    }

    public void close() throws CloseException {
    }
}

