/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authentication;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthenticationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;

public class DNListAuthenticationController
implements GCUBEServiceAuthenticationController {
    private GCUBEServiceSecurityManager securityManager;
    private GCUBELog logger = new GCUBELog((Object)this);
    private String TRUSTED_CA_LIST = "trustedca";
    private Set<String> trustedCADN;

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.securityManager = securityManager;
        String trustedCaListString = (String)ctxt.getProperty(this.TRUSTED_CA_LIST, new boolean[0]);
        if (trustedCaListString == null) {
            trustedCaListString = (String)GHNContext.getContext().getProperty(this.TRUSTED_CA_LIST, new boolean[0]);
        }
        if (trustedCaListString == null) {
            throw new Exception("Invalid configuration, no trusted CA list");
        }
        this.logger.debug((Object)("Trusted CA list " + trustedCaListString));
        String[] splittedString = trustedCaListString.split("|");
        this.trustedCADN = new HashSet<String>();
        for (String trustedCa : splittedString) {
            this.logger.debug((Object)("Adding " + trustedCa));
            this.trustedCADN.add(trustedCa);
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    public void authenticateCall(Map<String, Object> parameters) throws GCUBEException {
        this.logger.debug((Object)"Authenticating call...");
        if (this.isSecurityEnabled()) {
            MessageContext context = (MessageContext)parameters.get("MESSAGE_CONTEXT");
            Subject subject = (Subject)context.getProperty("callerSubject");
            if (subject == null) {
                throw new GCUBEUnrecoverableException("No subject found in the call");
            }
            Set<Object> creds = subject.getPublicCredentials();
            boolean found = false;
            if (creds != null) {
                Iterator<Object> credIter = creds.iterator();
                while (credIter.hasNext() && !found) {
                    Object p = credIter.next();
                    X509Certificate[] certs = null;
                    if (p instanceof X509Certificate[]) {
                        certs = (X509Certificate[])p;
                    } else if (p instanceof X509Certificate) {
                        certs = new X509Certificate[]{(X509Certificate)p};
                    }
                    for (int i = 0; i < certs.length && !found; ++i) {
                        Principal issuerDn = certs[i].getIssuerDN();
                        if (issuerDn == null) continue;
                        String name = issuerDn.getName();
                        this.logger.debug((Object)("Checking the dn " + name));
                        found = this.trustedCADN.contains(name);
                        this.logger.debug((Object)("Found " + found));
                    }
                }
            }
            if (!found) {
                throw new GCUBEUnrecoverableException("The Subject provided is not authenticated");
            }
        } else {
            this.logger.debug((Object)"No security enabled, nothing to do");
        }
    }
}

