/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration.test;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBEAuthzPolicy;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.core.impl.SAMLSecurityCredentials;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.SAMLAuthzAssertionTokenBuilder;
import org.gcube.common.vomanagement.security.authorisation.utils.AssertionGenerator;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.ietf.jgss.GSSCredential;
import org.opensaml.SAMLAssertion;

public class GCUBETestSamlAssertionServiceSecurityManager
implements GCUBEServiceSecurityManager {
    protected GCUBELog logger;
    protected GCUBEServiceContext context;
    protected Map<Thread, GSSCredential> callCredentials = Collections.synchronizedMap(new WeakHashMap());
    private GCUBEProducer<GCUBEServiceSecurityManager.LifetimeTopic, Object> producer = new GCUBEProducer();
    private SecurityCredentials serviceCredentials;
    private SAMLAssertion assertion;
    private boolean propagateCallerCredentials = true;
    private boolean securityEnabled = true;

    public GCUBETestSamlAssertionServiceSecurityManager() {
        this.logger = new GCUBELog((Object)this);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        if (credentials.length == 0) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        GSSCredential assertionCredentials = (GSSCredential)credentials[0].getCredentialsAsObject();
        this.logger.debug((Object)("Using credentials of the assertion (" + assertionCredentials.getName() + ") in thread " + thread.getName() + "(" + thread.getId() + ")"));
        this.callCredentials.put(thread, assertionCredentials);
    }

    public SecurityCredentials getCredentials() {
        GSSCredential internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred != null) {
            this.logger.debug((Object)"Credentials found for the current thread");
            return new GSSSecurityCredentials(internalCred);
        }
        if (this.propagateCallerCredentials) {
            this.logger.debug((Object)"Credentials not set, using caller credentials");
            try {
                return this.getCallerCredentials();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to find caller credentials", (Throwable)e);
                return null;
            }
        }
        this.logger.debug((Object)"Credentials not set, using service credentials");
        try {
            return this.getServiceCredentials();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to find service credentials", (Throwable)e);
            return null;
        }
    }

    public void setUserCredentials(String userName, String role) throws Exception {
        SAMLAssertion assertion;
        AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
        samlAssertionGenerator.setLifetimeSec(5000);
        samlAssertionGenerator.setUserId(userName);
        samlAssertionGenerator.addRole(role);
        this.assertion = assertion = samlAssertionGenerator.generate();
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        if (this.isSecurityEnabled()) {
            this.logger.debug((Object)"setting security parameters");
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", this.getCredentials().getCredentialsAsObject());
            org.apache.axis.message.SOAPEnvelope envelope = new org.apache.axis.message.SOAPEnvelope();
            SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(this.assertion);
            SOAPMessage newM = builder.buildMessage((SOAPEnvelope)envelope);
            Iterator headers = newM.getSOAPHeader().getChildElements();
            SOAPHeaderElement wssSecurity = null;
            while (headers.hasNext() && wssSecurity == null) {
                SOAPHeaderElement element = (SOAPHeaderElement)headers.next();
                if (!element.getNodeName().equals("wsse:Security")) continue;
                wssSecurity = element;
                stub.setHeader(wssSecurity);
            }
            stub._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            stub._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        }
    }

    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        this.logger.debug((Object)"Initialising...");
        this.context = ctxt;
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.POLICYUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
        this.logger.debug((Object)"Intialisation completed");
    }

    public void subscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.subscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    public void unsubscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.unsubscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    public SecurityCredentials getServiceCredentials() throws Exception {
        return this.serviceCredentials;
    }

    public SecurityCredentials getCallerCredentials() throws Exception {
        return new SAMLSecurityCredentials(this.getCallerSAMLAssertion());
    }

    public GCUBEAuthzPolicy getPolicy() {
        return new GCUBEPolicy.GCUBENoPolicy();
    }

    public boolean needServiceCredentials() {
        return true;
    }

    private SAMLAssertion getCallerSAMLAssertion() {
        this.logger.debug((Object)"getting caller SAML assertion...");
        MessageContext msgCtx = MessageContext.getCurrentContext();
        SAMLAssertion assertion = (SAMLAssertion)msgCtx.getProperty("org.globus.security.authorization.samlAssertion");
        if (assertion == null) {
            this.logger.warn((Object)"The SAML Assertion is null!");
        } else {
            this.logger.debug((Object)("SAML assertion = " + assertion.toString()));
        }
        return assertion;
    }

    @Deprecated
    public void useCredentials(GSSCredential credentials) throws Exception {
        this.logger.error((Object)"Invalid credentials set");
    }

    public void propagateCallerCredentials(boolean propagateCallerCredentials) {
    }

    public static void main(String[] args) throws Exception {
        AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
        samlAssertionGenerator.setLifetimeSec(5000);
        samlAssertionGenerator.setUserId("ciro");
        samlAssertionGenerator.addRole("admin");
        SAMLAssertion assertion = samlAssertionGenerator.generate();
        org.apache.axis.message.SOAPEnvelope envelope = new org.apache.axis.message.SOAPEnvelope();
        SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(assertion);
        SOAPMessage newM = builder.buildMessage((SOAPEnvelope)envelope);
        Iterator headers = newM.getSOAPHeader().getChildElements();
        while (headers.hasNext()) {
            SOAPElement element = (SOAPElement)headers.next();
            System.out.println(element.getNodeName());
            System.out.println(element.getClass());
        }
    }

    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
    }
}

