/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration;

import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.CredentialConsumer;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.security.GCUBEAuthzPolicy;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicyFactory;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GCUBEServiceSecurityManagerImpl
extends GCUBESecurityManagerImpl
implements GCUBEServiceSecurityManager {
    private GSSCredential serviceCredentials;
    protected GCUBEServiceContext context;
    private GCUBEProducer<GCUBEServiceSecurityManager.LifetimeTopic, Object> producer = new GCUBEProducer();
    private GCUBEPolicy policy;
    private GCUBEPolicyFactory policyFactory;
    private boolean propagateCallerCredentials = true;

    public void initialise(GCUBEServiceContext context) throws Exception {
        this.context = context;
        this.logger = context.getLogger();
        this.policyFactory = (GCUBEPolicyFactory)GHNContext.getImplementation(GCUBEPolicyFactory.class);
        this.policyFactory.initialise(this.context);
        this.subscribeForCredentials();
        this.subscribeForPolicy(context);
        this.logger.trace((Object)("security manager initialised for " + context.getServiceClass() + ":" + context.getName()));
        this.logger.trace((Object)("is security enabled?" + this.isSecurityEnabled()));
    }

    public synchronized GCUBEAuthzPolicy getPolicy() {
        return this.policy;
    }

    protected synchronized void setPolicy(GCUBEPolicy policy) {
        this.policy = policy;
        this.logger.trace((Object)("setting service policy to " + policy));
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.POLICYUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
    }

    public SecurityCredentials getServiceCredentials() throws Exception {
        return new GSSSecurityCredentials(this.serviceCredentials);
    }

    protected synchronized void setServiceCredentials(GSSCredential credentials) {
        this.serviceCredentials = credentials;
        this.logger.trace((Object)("setting service credentials to " + (credentials == null ? "no credentials" : credentials.toString())));
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.CREDENTIALUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
    }

    public void subscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.subscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    public void unsubscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.unsubscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    protected void subscribeForCredentials() throws Exception {
        if (!this.isSecurityEnabled() || !this.needServiceCredentials()) {
            this.logger.info((Object)("no credentials are needed for service " + this.context.getServiceClass() + ":" + this.context.getName()));
            this.setServiceCredentials(null);
            return;
        }
        this.logger.info((Object)("subscribing for credentials for service " + this.context.getServiceClass() + ":" + this.context.getName()));
        this.setServiceCredentials(this.getHostCredentials());
        CredentialConsumer credentialConsumer = new CredentialConsumer(){

            public GCUBEServiceContext getServiceContext() {
                return GCUBEServiceSecurityManagerImpl.this.context;
            }

            protected void onCredentialDelegation(Events.CredentialDelegationEvent event) {
                GCUBEServiceSecurityManagerImpl.this.setServiceCredentials(((Events.CredentialPayload)event.getPayload()).getCredentials());
            }
        };
        GHNContext.getContext().subscribeForCredential(credentialConsumer);
    }

    protected void subscribeForPolicy(GCUBEServiceContext context) throws Exception {
        if (!this.isSecurityEnabled()) {
            this.setPolicy(new GCUBEPolicy.GCUBENoPolicy());
            return;
        }
        String policyString = null;
        policyString = ":-)";
        this.setPolicy(policyString == null ? new GCUBEPolicy.GCUBENoPolicy() : this.policyFactory.getGCUBEPolicy(policyString));
    }

    public SecurityCredentials getCredentials() {
        GSSCredential internalCred = (GSSCredential)this.callCredentials.get(Thread.currentThread());
        if (internalCred != null) {
            this.logger.debug((Object)"Credentials found for the current thread");
            return new GSSSecurityCredentials(internalCred);
        }
        if (this.propagateCallerCredentials) {
            this.logger.debug((Object)"Credentials not set, using caller credentials");
            try {
                return this.getCallerCredentials();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to find caller credentials", (Throwable)e);
                return null;
            }
        }
        this.logger.debug((Object)"Credentials not set, using service credentials");
        try {
            return this.getServiceCredentials();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to find service credentials", (Throwable)e);
            return null;
        }
    }

    public boolean isSecurityEnabled() {
        return GHNContext.getContext().isSecurityEnabled();
    }

    public SecurityCredentials getCallerCredentials() throws Exception {
        if (!this.isSecurityEnabled()) {
            return null;
        }
        Subject subject = this.getCallerSubject();
        if (this.isSecurityEnabled() && subject != null && JaasGssUtil.getCredential((Subject)subject) != null) {
            GSSCredential callerCredentials = JaasGssUtil.getCredential((Subject)subject);
            return new GSSSecurityCredentials(callerCredentials);
        }
        this.logger.warn((Object)"Could not extract credentials from incoming call because: ");
        throw new Exception("Could not extract credentials from incoming call");
    }

    protected String getName() {
        return this.context.getName();
    }

    public boolean needServiceCredentials() {
        return true;
    }

    private Subject getCallerSubject() {
        MessageContext msgCtx = MessageContext.getCurrentContext();
        Subject s = (Subject)msgCtx.getProperty("invocationSubject");
        if (s == null) {
            this.logger.warn((Object)"The caller subject is null!");
        }
        return s;
    }

    private GSSCredential getHostCredentials() throws SecurityException, GSSException {
        this.logger.debug((Object)"Getting host Credentials for service ... ");
        GSSCredential hostCredentials = null;
        try {
            hostCredentials = JaasGssUtil.getCredential((Subject)SecurityManager.getManager().getSystemSubject());
            this.logger.debug((Object)("Host Credentials name " + hostCredentials.getName()));
        }
        catch (SecurityException e) {
            this.logger.error((Object)"Cannot get local host credentials", (Throwable)e);
            throw e;
        }
        return hostCredentials;
    }

    public void propagateCallerCredentials(boolean propagateCallerCredentials) {
        this.propagateCallerCredentials = propagateCallerCredentials;
    }
}

