/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages;

import com.sun.xacml.Indenter;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class NamespaceAwareRequestCtx
extends RequestCtx {
    public static final String XACML_CONTEXT_PREFIX = "xacml-context";
    public static final String XACML_CONTEXT_NAMESPACE = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
    private String resourceContent;

    public NamespaceAwareRequestCtx(Set<Subject> subjects, Set<Attribute> resources, Set<Attribute> actions, Set<Attribute> environments) {
        super(subjects, resources, actions, environments);
    }

    public NamespaceAwareRequestCtx(Set<Subject> subjects, Set<Attribute> resources, Set<Attribute> actions, Set<Attribute> environments, Node node, String resourceContent) throws IllegalArgumentException {
        super(subjects, resources, actions, environments, node, resourceContent);
        this.resourceContent = resourceContent;
    }

    public NamespaceAwareRequestCtx(Set<Subject> subjects, Set<Attribute> resources, Set<Attribute> actions, Set<Attribute> environments, Node node) {
        super(subjects, resources, actions, environments, node);
    }

    public NamespaceAwareRequestCtx(Set<Subject> subjects, Set<Attribute> resources, Set<Attribute> actions, Set<Attribute> environments, String resourceContent) {
        super(subjects, resources, actions, environments, resourceContent);
        this.resourceContent = resourceContent;
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String topIndent = indenter.makeString();
        out.println(topIndent + "<" + XACML_CONTEXT_PREFIX + ":Request " + "xmlns:" + XACML_CONTEXT_PREFIX + "=\"" + XACML_CONTEXT_NAMESPACE + "\">");
        indenter.in();
        String indent = indenter.makeString();
        indenter.in();
        Set subjects = this.getSubjects();
        for (Subject subject : subjects) {
            out.print(indent + "<" + XACML_CONTEXT_PREFIX + ":Subject SubjectCategory=\"" + subject.getCategory().toString() + "\"");
            Set subjectAttrs = subject.getAttributes();
            if (subjectAttrs.size() == 0) {
                out.println("/>");
                continue;
            }
            out.println(">");
            this.encodeAttributes(subjectAttrs, out, indenter);
            out.println(indent + "</" + XACML_CONTEXT_PREFIX + ":Subject>");
        }
        Set resource = this.getResource();
        if (resource.size() != 0 || this.resourceContent != null) {
            out.println(indent + "<" + XACML_CONTEXT_PREFIX + ":Resource>");
            if (this.resourceContent != null) {
                out.println(indenter.makeString() + "<" + XACML_CONTEXT_PREFIX + ":ResourceContent>" + this.resourceContent + "</" + XACML_CONTEXT_PREFIX + ":ResourceContent>");
            }
            this.encodeAttributes(resource, out, indenter);
            out.println(indent + "</" + XACML_CONTEXT_PREFIX + ":Resource>");
        } else {
            out.println(indent + "<" + XACML_CONTEXT_PREFIX + ":Resource/>");
        }
        Set action = this.getAction();
        if (action.size() != 0) {
            out.println(indent + "<" + XACML_CONTEXT_PREFIX + ":Action>");
            this.encodeAttributes(action, out, indenter);
            out.println(indent + "</" + XACML_CONTEXT_PREFIX + ":Action>");
        } else {
            out.println(indent + "<" + XACML_CONTEXT_PREFIX + ":Action/>");
        }
        Set environment = this.getEnvironmentAttributes();
        if (this.getEnvironmentAttributes().size() != 0) {
            out.println(indent + "<" + XACML_CONTEXT_PREFIX + ":Environment>");
            this.encodeAttributes(environment, out, indenter);
            out.println(indent + "</" + XACML_CONTEXT_PREFIX + ":Environment>");
        }
        indenter.out();
        indenter.out();
        out.println(topIndent + "</" + XACML_CONTEXT_PREFIX + ":Request>");
    }

    public void insertIntoDocument(Element parent) {
        Document document = parent.getOwnerDocument();
        Element requestElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Request");
        parent.appendChild(requestElement);
        Set subjects = this.getSubjects();
        for (Subject subject : subjects) {
            Element subjectElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Subject");
            subjectElement.setAttribute("SubjectCategory", subject.getCategory().toString());
            Set subjectAttrs = subject.getAttributes();
            for (Attribute subjAttribute : subjectAttrs) {
                this.addAttribute(document, subjectElement, subjAttribute);
            }
            requestElement.appendChild(subjectElement);
        }
        Set resource = this.getResource();
        Element resourceElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Resource");
        requestElement.appendChild(resourceElement);
        if (this.resourceContent != null) {
            Element resourceContentElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:ResourceContent");
            Text resuurceContentText = document.createTextNode(this.resourceContent);
            resourceContentElement.appendChild(resuurceContentText);
            resourceElement.appendChild(resourceContentElement);
        }
        for (Attribute resAttribute : resource) {
            this.addAttribute(document, resourceElement, resAttribute);
        }
        Set action = this.getAction();
        Element actionElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Action");
        requestElement.appendChild(actionElement);
        for (Attribute actionAttribute : action) {
            this.addAttribute(document, actionElement, actionAttribute);
        }
        Set environment = this.getEnvironmentAttributes();
        if (this.getEnvironmentAttributes().size() != 0) {
            Element environmentElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Environment");
            requestElement.appendChild(environmentElement);
            for (Attribute environmentAttribute : environment) {
                this.addAttribute(document, environmentElement, environmentAttribute);
            }
        }
    }

    private void encodeAttributes(Set attributes, PrintStream outStream, Indenter indenter) {
        String indent = indenter.makeString();
        PrintStream out = new PrintStream(outStream);
        for (Attribute attr : attributes) {
            out.println(indent + this.encodeWithNamespace(attr));
        }
    }

    private String encodeWithNamespace(Attribute attribute) {
        String encoded = "<xacml-context:Attribute AttributeId=\"" + attribute.getId().toString() + "\" " + "DataType=\"" + attribute.getType().toString() + "\"";
        if (attribute.getIssuer() != null) {
            encoded = encoded + " Issuer=\"" + attribute.getIssuer() + "\"";
        }
        if (attribute.getIssueInstant() != null) {
            encoded = encoded + " IssueInstant=\"" + attribute.getIssueInstant().encode() + "\"";
        }
        encoded = encoded + ">" + attribute.getValue().encodeWithTags(false) + "</" + XACML_CONTEXT_PREFIX + ":Attribute>";
        return encoded;
    }

    private void addAttribute(Document document, Element parent, Attribute attribute) {
        Element attrElement = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:Attribute");
        attrElement.setAttribute("AttributeId", attribute.getId().toString());
        attrElement.setAttribute("DataType", attribute.getType().toString());
        if (attribute.getIssuer() != null) {
            attrElement.setAttribute("Issuer", attribute.getIssuer());
        }
        if (attribute.getIssueInstant() != null) {
            attrElement.setAttribute("IssueInstant", attribute.getIssueInstant().encode());
        }
        Element attrValue = document.createElementNS(XACML_CONTEXT_NAMESPACE, "xacml-context:AttributeValue");
        Text valueText = document.createTextNode(attribute.getValue().encode());
        attrValue.appendChild(valueText);
        attrElement.appendChild(attrValue);
        parent.appendChild(attrElement);
    }
}

