/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.occi;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.Client;
import cz.cesnet.cloud.occi.api.EntityBuilder;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.api.http.HTTPClient;
import cz.cesnet.cloud.occi.api.http.auth.VOMSAuthentication;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.exception.RenderingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.gcube.vomanagement.occi.JocciInterface;

public class FedcloudOCCI
implements JocciInterface {
    private String proxyCertificate;
    private String trustStorePath;
    private String endpoint;
    private Client client;
    protected URI location;
    protected EntityBuilder eb;
    protected Model model;

    public FedcloudOCCI(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void connect() throws CommunicationException {
        if (this.client == null) {
            this.client = this.createClient(this.proxyCertificate, this.trustStorePath);
            this.client.connect();
            System.out.println("Connected to endpoint: " + this.endpoint);
            Model model = this.client.getModel();
            this.eb = new EntityBuilder(model);
        }
    }

    private Client createClient(String proxyCertificate, String trustStorePath) throws CommunicationException {
        HTTPClient response = null;
        if (proxyCertificate != null) {
            VOMSAuthentication authentication = new VOMSAuthentication(proxyCertificate);
            authentication.setCAPath(trustStorePath);
            response = new HTTPClient(URI.create(this.endpoint), (Authentication)authentication);
        } else {
            response = new HTTPClient(URI.create(this.endpoint));
        }
        return response;
    }

    @Override
    public List<URI> getComputeList() {
        try {
            List list = this.client.list("compute");
            System.out.println("Compute Locations: ");
            for (URI uri : list) {
                System.out.println(uri);
            }
            return list;
        }
        catch (CommunicationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<URI> getNetList() {
        try {
            List list = this.client.list("network");
            System.out.println("Network Locations: ");
            for (URI uri : list) {
                System.out.println(uri);
            }
            return list;
        }
        catch (CommunicationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<URI> getStorageList() {
        try {
            List list = this.client.list("storage");
            System.out.println("Storage Locations: ");
            for (URI uri : list) {
                System.out.println(uri);
            }
            return list;
        }
        catch (CommunicationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<Mixin> getOsTemplateList() {
        try {
            Model model = this.client.getModel();
            List mixins = model.findRelatedMixins("os_tpl");
            if (mixins.isEmpty()) {
                System.err.println("No os template mixins available. Quiting.");
            } else {
                System.out.println(mixins.size() + "" + " AVAILABLE OS TEMPLATES MIXINS");
                for (int i = 0; i < mixins.size(); ++i) {
                    System.out.println(mixins.get(i));
                }
            }
            return mixins;
        }
        catch (AmbiguousIdentifierException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<Mixin> getResourcesTemplateList() {
        try {
            Model model = this.client.getModel();
            List mixins = model.findRelatedMixins("resource_tpl");
            if (mixins.isEmpty()) {
                System.err.println("No resources template mixins available. Quiting.");
            } else {
                System.out.println(mixins.size() + "" + " AVAILABLE RESOURCES TEMPLATES MIXINS");
                for (int i = 0; i < mixins.size(); ++i) {
                    System.out.println(mixins.get(i));
                }
            }
            return mixins;
        }
        catch (AmbiguousIdentifierException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin, String vmName) throws InvalidAttributeValueException, AmbiguousIdentifierException, IOException {
        try {
            this.createResourceAndDescribe(osMixin, resourceMixin, vmName, null, null, null);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    @Override
    public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin, String vmName, URL context) throws InvalidAttributeValueException, AmbiguousIdentifierException, IOException {
        try {
            this.createResourceAndDescribe(osMixin, resourceMixin, vmName, null, null, context);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    @Override
    public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin, String vmName, File path) throws InvalidAttributeValueException, AmbiguousIdentifierException, IOException {
        try {
            this.createResourceAndDescribe(osMixin, resourceMixin, vmName, path, null, null);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    @Override
    public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin, String vmName, String script) throws InvalidAttributeValueException, AmbiguousIdentifierException, IOException {
        try {
            this.createResourceAndDescribe(osMixin, resourceMixin, vmName, null, script, null);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e);
        }
    }

    public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin, String vmName, File path, String script, URL context) throws InvalidAttributeValueException, AmbiguousIdentifierException, IOException {
        try {
            System.out.println("Creating compute resource...");
            Model model = this.client.getModel();
            EntityBuilder eb = new EntityBuilder(model);
            Resource compute = eb.getResource("compute");
            System.out.println("Mixin:");
            compute.addMixin(osMixin);
            compute.addMixin(resourceMixin);
            System.out.println(osMixin.toText());
            System.out.println(resourceMixin.toText());
            compute.setTitle(vmName);
            compute.addAttribute("occi.compute.hostname", vmName);
            if (script != null) {
                byte[] message = script.getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                compute.addMixin(model.findMixin(URI.create("http://schemas.openstack.org/compute/instance#user_data")));
                compute.addAttribute("org.openstack.compute.user_data", encoded);
            }
            if (context != null) {
                String inputLine;
                URLConnection yc = context.openConnection();
                BufferedReader input = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                StringBuffer buffer = new StringBuffer();
                while ((inputLine = input.readLine()) != null) {
                    buffer.append(inputLine + "\n");
                }
                System.out.println(inputLine);
                String bufferScript = buffer.substring(0, buffer.length());
                System.out.println(bufferScript);
                byte[] message = bufferScript.getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                compute.addMixin(model.findMixin(URI.create("http://schemas.openstack.org/compute/instance#user_data")));
                compute.addAttribute("org.openstack.compute.user_data", encoded);
                input.close();
            }
            if (path != null) {
                String a;
                BufferedReader input = new BufferedReader(new FileReader(path));
                StringBuffer buffer = new StringBuffer();
                while ((a = input.readLine()) != null) {
                    buffer.append(a + "\n");
                }
                String bufferScript = buffer.substring(0, buffer.length());
                System.out.println(bufferScript);
                byte[] message = bufferScript.getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                compute.addMixin(model.findMixin(URI.create("http://schemas.openstack.org/compute/instance#user_data")));
                compute.addAttribute("org.openstack.compute.user_data", encoded);
                System.out.println(encoded);
            }
            URI location = this.client.create((Entity)compute);
            System.out.println("Created compute instance at location: '" + location + "'.");
            List entities = this.client.describe(location);
            System.out.println("Description:");
            System.out.println(((Entity)entities.get(0)).toText());
            System.out.println("Waiting for compute to become active...");
            Thread.sleep(5000L);
            for (int i = 0; i < 999; ++i) {
                entities = this.client.describe(location);
                if (((Entity)entities.get(0)).getValue("occi.compute.state").equals("active")) {
                    System.out.println("Compute active.");
                    break;
                }
                Thread.sleep(5000L);
                System.out.println(".");
                Thread.sleep(5000L);
            }
        }
        catch (CommunicationException | EntityBuildingException | RenderingException | InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void startResource(URI resourceType) throws InterruptedException {
        try {
            this.connect();
            System.out.println("Starting created compute...");
            ActionInstance actionInstance = this.eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#start"));
            boolean status = this.client.trigger(resourceType, actionInstance);
            if (status) {
                System.out.println("Triggered: OK");
            } else {
                System.out.println("Triggered: FAIL");
            }
        }
        catch (CommunicationException | EntityBuildingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stopResource(URI resourceType) {
        try {
            this.connect();
            System.out.println("Stopping compute...");
            ActionInstance actionInstance = this.eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#stop"));
            boolean status = this.client.trigger(resourceType, actionInstance);
            if (status) {
                System.out.println("Triggered: OK");
            } else {
                System.out.println("Triggered: FAIL");
            }
        }
        catch (CommunicationException | EntityBuildingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void deleteResource(URI resourceType) {
        try {
            this.connect();
            System.out.println("Deleting created resource...");
            boolean status = this.client.delete(resourceType);
            if (status) {
                System.out.println("Deleted: OK");
            } else {
                System.out.println("Deleted: FAIL");
            }
        }
        catch (CommunicationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setTrustStore(String path) {
        this.trustStorePath = path;
    }

    @Override
    public void setCertificate(String path) {
        this.proxyCertificate = path;
    }
}

