/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.events.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

class TypeChecker {
    TypeChecker() {
    }

    public static boolean matchTypes(Type paramType, Type eventType) {
        TypeChecker.print(paramType, eventType);
        if (paramType instanceof Class) {
            return TypeChecker.matchClass((Class)Class.class.cast(paramType), eventType);
        }
        if (paramType instanceof WildcardType) {
            return TypeChecker.matchWildcardType((WildcardType)WildcardType.class.cast(paramType), eventType);
        }
        if (paramType instanceof ParameterizedType) {
            return TypeChecker.matchParameterizedType((ParameterizedType)ParameterizedType.class.cast(paramType), eventType);
        }
        return false;
    }

    public static boolean matchWildcardType(WildcardType paramType, Type eventType) {
        if (eventType instanceof WildcardType) {
            return TypeChecker.matchTypes(paramType.getUpperBounds()[0], ((WildcardType)WildcardType.class.cast(eventType)).getUpperBounds()[0]);
        }
        return TypeChecker.matchTypes(paramType.getUpperBounds()[0], eventType);
    }

    public static boolean matchParameterizedType(ParameterizedType paramType, Type eventType) {
        if (eventType instanceof ParameterizedType) {
            return TypeChecker.matchParameterizedTypes(paramType, (ParameterizedType)ParameterizedType.class.cast(eventType));
        }
        return false;
    }

    public static boolean matchParameterizedTypes(ParameterizedType paramType, ParameterizedType eventType) {
        return TypeChecker.matchTypes(paramType.getRawType(), eventType.getRawType()) && TypeChecker.matchArguments(paramType.getActualTypeArguments(), eventType.getActualTypeArguments());
    }

    public static boolean matchArguments(Type[] paramArgumentTypes, Type[] eventArgumentTypes) {
        for (int i = 0; i < paramArgumentTypes.length; ++i) {
            if (TypeChecker.matchTypes(paramArgumentTypes[i], eventArgumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchClass(Class<?> paramType, Type eventType) {
        if (eventType instanceof Class) {
            return TypeChecker.matchClasses(paramType, (Class)Class.class.cast(eventType));
        }
        if (eventType instanceof WildcardType) {
            return false;
        }
        return TypeChecker.matchClass(paramType, (ParameterizedType)ParameterizedType.class.cast(eventType));
    }

    public static boolean matchClass(Class<?> paramType, ParameterizedType eventType) {
        TypeChecker.print(paramType, eventType);
        return TypeChecker.matchClass(paramType, ((ParameterizedType)ParameterizedType.class.cast(eventType)).getRawType());
    }

    public static boolean matchClasses(Class<?> paramType, Class<?> eventType) {
        return paramType.isAssignableFrom(eventType);
    }

    public static void print(Type t1, Type t2) {
    }
}

