/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.Changelog;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.entities.facets.LocationFacetImpl;

@JsonDeserialize(as=LocationFacetImpl.class)
@TypeMetadata(name="LocationFacet", description="LocationFacet captures information about the geographic location characterizing the associated resource. It should not be confused with {@link CoverageFacet}. LocationFacet describes where a resource is located, optionally using GeoJSON spatial geometry. It is typically used to locate a data centre or to represent the geographic reference of a legal or organizational body acting as an actor within the infrastructure.", version="1.1.0")
@Changelog(value={@Change(version="1.1.0", description="General revision of the facet to improve clarity and usability; removed 'latitude' and 'longitude' in favor of 'spatialGeometry' for greater flexibility; removed 'country' to avoid collisions with 'location' when the intended location represents a country; 'location' is no longer limited to a city name and can represent any human-readable location description."), @Change(version="1.0.0", description="First Version")})
public interface LocationFacet
extends Facet {
    public static final String NAME = "LocationFacet";
    public static final String VERSION = "1.1.0";
    public static final String LOCATION_PROPERTY = "location";
    public static final String SPATIAL_GEOMETRY_PROPERTY = "spatialGeometry";

    public static LocationFacet getDefaultInstance() {
        return new LocationFacetImpl();
    }

    @ISProperty(name="location", description="A human english name for the location, e.g., a city name, a country name, a site name, a region name, etc.")
    public String getLocation();

    public void setLocation(String var1);

    @ISProperty(name="spatialGeometry", description="Spatial Geometry in GeoJSON format")
    public ObjectNode getSpatialGeometry();

    public void setSpatialGeometry(ObjectNode var1);
}

