/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.knowledge;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.knowledge.TypeInformation;
import org.gcube.informationsystem.model.knowledge.UsageKnowledge;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelKnowledge<T, TI extends TypeInformation<T>> {
    private static final Logger logger = LoggerFactory.getLogger(ModelKnowledge.class);
    protected TI typeInformation;
    protected Map<AccessType, Tree<T>> trees;
    protected UsageKnowledge<Map.Entry<String, PropertyDefinition>> propertyUsage;
    protected Map<AccessType, UsageKnowledge<LinkedEntity>> erTypesUsage;
    protected Map<String, AccessType> locate;

    public ModelKnowledge(TI typeInformation) {
        this.typeInformation = typeInformation;
        this.reset();
    }

    protected void reset() {
        AccessType[] modelTypes;
        this.trees = new HashMap<AccessType, Tree<T>>();
        this.erTypesUsage = new HashMap<AccessType, UsageKnowledge<LinkedEntity>>();
        this.locate = new HashMap<String, AccessType>();
        for (AccessType accessType : modelTypes = AccessType.getModelTypes()) {
            Tree tree = new Tree(this.typeInformation);
            this.trees.put(accessType, tree);
            if (accessType == AccessType.PROPERTY) {
                this.propertyUsage = new UsageKnowledge(accessType);
                continue;
            }
            UsageKnowledge usageKnowledge = new UsageKnowledge(accessType);
            this.erTypesUsage.put(accessType, usageKnowledge);
        }
    }

    protected void addUsage(LinkedEntity linkedEntity, UsageKnowledge<LinkedEntity> relationUsage, UsageKnowledge<LinkedEntity> targetEntityUsage) {
        if (linkedEntity != null) {
            UsageKnowledge<LinkedEntity> resourceUsage = this.erTypesUsage.get((Object)AccessType.RESOURCE);
            String source = linkedEntity.getSource();
            resourceUsage.add(source, linkedEntity);
            String relation = linkedEntity.getRelation();
            relationUsage.add(relation, linkedEntity);
            String target = linkedEntity.getTarget();
            targetEntityUsage.add(target, linkedEntity);
        }
    }

    protected void addAllUsage(Collection<LinkedEntity> linkedEntities, UsageKnowledge<LinkedEntity> relationUsage, UsageKnowledge<LinkedEntity> targetEntityUsage) {
        if (linkedEntities != null) {
            for (LinkedEntity le : linkedEntities) {
                this.addUsage(le, relationUsage, targetEntityUsage);
            }
        }
    }

    protected void addPropertyUsage(T t, Set<PropertyDefinition> properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        String typeName = this.typeInformation.getIdentifier(t);
        for (PropertyDefinition propertyDefinition : properties) {
            PropertyTypeName propertyTypeName = ((PropertyDefinitionImpl)propertyDefinition).getPropertyTypeName();
            if (!propertyTypeName.isGenericType()) continue;
            AbstractMap.SimpleEntry<String, PropertyDefinition> entry = new AbstractMap.SimpleEntry<String, PropertyDefinition>(typeName, propertyDefinition);
            this.propertyUsage.add(propertyTypeName.getGenericClassName(), entry);
        }
    }

    protected void addEntityMetadataUsage(T t) {
        Type type = TypeMapper.createTypeDefinition(EntityElement.class);
        this.addPropertyUsage(t, type.getProperties());
    }

    protected void addRelationMetadataUsage(T t) {
        Type type = TypeMapper.createTypeDefinition(RelationElement.class);
        this.addPropertyUsage(t, type.getProperties());
    }

    protected void addPropagationConstraintUsage(T t) {
        Type type = TypeMapper.createTypeDefinition(Relation.class);
        this.addPropertyUsage(t, type.getProperties());
    }

    public void addAllType(Collection<T> types) {
        HashSet<T> toRetry = new HashSet<T>();
        for (T t : types) {
            logger.trace("Going to add {}", (Object)this.typeInformation.getIdentifier(t));
            try {
                this.addType(t);
            }
            catch (RuntimeException e) {
                toRetry.add(t);
            }
        }
        if (types.size() == toRetry.size()) {
            throw new RuntimeException("Unable to find parent for " + ((Object)toRetry).toString());
        }
        if (toRetry.size() > 0) {
            this.addAllType(toRetry);
        }
    }

    public void addType(T t) {
        AccessType accessType = this.typeInformation.getAccessType(t);
        String typeName = this.typeInformation.getIdentifier(t);
        if (this.locate.get(typeName) != null) {
            logger.trace("The type {} was already added to the ModelKnowledge", (Object)typeName);
            return;
        }
        Tree<T> tree = this.trees.get((Object)accessType);
        tree.addNode(t);
        this.locate.put(typeName, accessType);
        UsageKnowledge<LinkedEntity> resourceUsage = this.erTypesUsage.get((Object)AccessType.RESOURCE);
        UsageKnowledge<LinkedEntity> facetUsage = this.erTypesUsage.get((Object)AccessType.FACET);
        UsageKnowledge<LinkedEntity> isRelatedToUsage = this.erTypesUsage.get((Object)AccessType.IS_RELATED_TO);
        UsageKnowledge<LinkedEntity> consistsOfUsage = this.erTypesUsage.get((Object)AccessType.CONSISTS_OF);
        switch (accessType) {
            case PROPERTY: {
                break;
            }
            case RESOURCE: {
                ResourceType resourceType = (ResourceType)t;
                this.addAllUsage(resourceType.getFacets(), consistsOfUsage, facetUsage);
                this.addAllUsage(resourceType.getResources(), isRelatedToUsage, resourceUsage);
                if (typeName.compareTo("Resource") != 0) break;
                this.addEntityMetadataUsage(t);
                break;
            }
            case FACET: {
                FacetType facetType = (FacetType)t;
                if (typeName.compareTo("Facet") == 0) {
                    this.addEntityMetadataUsage(t);
                }
                this.addPropertyUsage(t, facetType.getProperties());
                break;
            }
            case IS_RELATED_TO: {
                IsRelatedToType isRelatedToType = (IsRelatedToType)t;
                if (typeName.compareTo("IsRelatedTo") == 0) {
                    this.addRelationMetadataUsage(t);
                    this.addPropagationConstraintUsage(t);
                }
                this.addPropertyUsage(t, isRelatedToType.getProperties());
                break;
            }
            case CONSISTS_OF: {
                ConsistsOfType consistsOfType = (ConsistsOfType)t;
                if (typeName.compareTo("ConsistsOf") == 0) {
                    this.addRelationMetadataUsage(t);
                    this.addPropagationConstraintUsage(t);
                }
                this.addPropertyUsage(t, consistsOfType.getProperties());
                break;
            }
        }
    }

    public Tree<T> getTree(AccessType accessType) {
        return this.trees.get((Object)accessType);
    }

    public UsageKnowledge<?> getModelTypesUsage(AccessType accessType) {
        List<AccessType> modelTypes = Arrays.asList(AccessType.getModelTypes());
        if (!modelTypes.contains((Object)accessType)) {
            throw new RuntimeException("Only ModelTypes are allowed, i.e. " + modelTypes.toString());
        }
        if (accessType == AccessType.PROPERTY) {
            return this.propertyUsage;
        }
        return this.erTypesUsage.get((Object)accessType);
    }

    public UsageKnowledge<LinkedEntity> getERTypesUsage(AccessType accessType) {
        List<AccessType> erTypes = Arrays.asList(AccessType.getERTypes());
        if (!erTypes.contains((Object)accessType)) {
            throw new RuntimeException("Only ERTypes are allowed, i.e. " + erTypes.toString());
        }
        return this.erTypesUsage.get((Object)accessType);
    }

    public UsageKnowledge<Map.Entry<String, PropertyDefinition>> getPropertyUsage() {
        return this.propertyUsage;
    }

    public UsageKnowledge<LinkedEntity> getResourceUsage() {
        return this.erTypesUsage.get((Object)AccessType.RESOURCE);
    }

    public UsageKnowledge<LinkedEntity> getFacetUsage() {
        return this.erTypesUsage.get((Object)AccessType.FACET);
    }

    public UsageKnowledge<LinkedEntity> getIsRelatedToUsage() {
        return this.erTypesUsage.get((Object)AccessType.IS_RELATED_TO);
    }

    public UsageKnowledge<LinkedEntity> getConsistsOfUsage() {
        return this.erTypesUsage.get((Object)AccessType.CONSISTS_OF);
    }

    public T getTypeByName(String typeName) throws RuntimeException {
        return this.getNodeByName(typeName).getNodeElement();
    }

    public Node<T> getNodeByName(String typeName) throws RuntimeException {
        AccessType accessType = this.locate.get(typeName);
        if (accessType == null) {
            throw new RuntimeException("The type " + typeName + " is not contained in the Knowledge");
        }
        Tree<T> tree = this.trees.get((Object)accessType);
        return tree.getNodeByIdentifier(typeName);
    }
}

