/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.informationsystem.types.impl.validator.AttributeValidatorReport;

public class ValidatorReport {
    protected Boolean valid = null;
    protected Map<String, AttributeValidatorReport> attributeValidatorReports = new HashMap<String, AttributeValidatorReport>();
    protected Map<Boolean, List<AttributeValidatorReport>> attributeValidatorReportByValidity = new HashMap<Boolean, List<AttributeValidatorReport>>();

    public ValidatorReport() {
        for (Boolean b : new Boolean[]{true, false}) {
            this.attributeValidatorReportByValidity.put(b, new ArrayList());
        }
    }

    public Collection<AttributeValidatorReport> getAttributeValidatorReports() {
        return this.attributeValidatorReports.values();
    }

    public void addAttributeValidatorReport(AttributeValidatorReport attributeValidatorReport) {
        boolean avrValid = attributeValidatorReport.isValid();
        this.valid = avrValid && (this.valid == null || this.valid != false);
        List<AttributeValidatorReport> reports = this.attributeValidatorReportByValidity.get(avrValid);
        reports.add(attributeValidatorReport);
        this.attributeValidatorReports.put(attributeValidatorReport.getFieldName(), attributeValidatorReport);
    }

    public AttributeValidatorReport getAttributeValidatorReport(String fieldName) {
        return this.attributeValidatorReports.get(fieldName);
    }

    public Boolean isValid() {
        return this.valid;
    }

    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (AttributeValidatorReport attributeValidatorReport : this.attributeValidatorReportByValidity.get(false)) {
            if (attributeValidatorReport.isValid()) continue;
            errors.addAll(attributeValidatorReport.getMessages());
        }
        return errors;
    }
}

