/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.validator;

import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.NullNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.AttributeDefinition;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.impl.validator.AttributeValidatorReport;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.AttributeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValidator {
    protected static Logger logger = LoggerFactory.getLogger(AttributeValidator.class);
    protected final boolean stopOnError;
    protected final AttributeDefinition attributeDefinition;
    protected final JsonNode value;
    protected final AttributeValidatorReport attributeValidatorReport;

    public AttributeValidator(AttributeDefinition attributeDefinition, JsonNode value) {
        this(attributeDefinition, value, false);
    }

    public AttributeValidator(AttributeDefinition attributeDefinition, JsonNode value, boolean stopOnError) {
        this.stopOnError = stopOnError;
        this.attributeDefinition = attributeDefinition;
        this.value = value;
        this.attributeValidatorReport = new AttributeValidatorReport();
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public AttributeValidatorReport getAttributeValidatorReport() {
        return this.attributeValidatorReport;
    }

    protected void addError(StringBuffer sb) {
        logger.trace(sb.toString());
        this.attributeValidatorReport.addMessage(sb.toString());
    }

    protected StringBuffer getNewStringBuffer(StringBuffer sb) {
        StringBuffer sbNew = null;
        if (sb == null) {
            sbNew = new StringBuffer();
            sbNew.append("The field '").append(this.attributeDefinition.getName()).append("'");
        } else {
            sbNew = new StringBuffer(sb);
        }
        return sbNew;
    }

    protected boolean validateNumber(Number number, StringBuffer sb) {
        StringBuffer sbInner;
        Integer max = null;
        Integer min = null;
        if (sb == null) {
            max = this.attributeDefinition.getMax();
            min = this.attributeDefinition.getMin();
        }
        boolean valid = true;
        if (max != null && number.doubleValue() > (double)max.intValue()) {
            valid = false;
            sbInner = this.getNewStringBuffer(sb);
            sbInner.append(number).append("is greater than the maximum value ").append(max);
            this.addError(sbInner);
            if (this.stopOnError) {
                return valid;
            }
        }
        if (min != null && number.doubleValue() < (double)min.intValue()) {
            valid = false;
            sbInner = this.getNewStringBuffer(sb);
            sbInner.append(number).append(" is lower than the minimum value ").append(min);
            this.addError(sbInner);
        }
        return valid;
    }

    protected boolean typeNotCompliant(JsonNode value, String expectedType, StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
            sb.append("The field '").append(this.attributeDefinition.getName());
        }
        StringBuffer sbInner = new StringBuffer(sb);
        sbInner.append(value).append("' is not a ").append(expectedType).append(" but it is a ").append(value.getNodeType().name());
        this.addError(sbInner);
        return false;
    }

    protected boolean validateString(JsonNode value, StringBuffer sb) {
        boolean valid = true;
        String regex = null;
        if (sb == null) {
            regex = this.attributeDefinition.getRegexp();
        }
        if (!value.isTextual()) {
            valid = this.typeNotCompliant(value, PropertyTypeName.BaseType.STRING.toString(), sb);
        } else {
            String stringValue = value.asText();
            if (regex != null && regex.length() > 0 && !stringValue.matches(regex)) {
                valid = false;
                StringBuffer sbInner = this.getNewStringBuffer(sb);
                sbInner.append(" does not match the pattern ").append(regex);
                this.addError(sbInner);
            }
        }
        return valid;
    }

    protected boolean validateDate(JsonNode value, StringBuffer sb) {
        boolean valid = true;
        if (!value.isTextual()) {
            valid = this.typeNotCompliant(value, PropertyTypeName.BaseType.DATE.toString(), sb);
        } else {
            String stringValue = value.asText();
            try {
                AttributeUtility.checkDateTimeString(stringValue);
            }
            catch (DateTimeParseException e) {
                valid = false;
                StringBuffer sbInner = this.getNewStringBuffer(sb);
                sbInner.append(" is not a valid date according to the pattern ").append("yyyy-MM-dd HH:mm:ss.SSS Z");
                this.addError(sbInner);
            }
        }
        return valid;
    }

    protected boolean validateByte(JsonNode value, StringBuffer sb) {
        boolean valid = true;
        if (!value.isBinary()) {
            valid = this.typeNotCompliant(value, PropertyTypeName.BaseType.BYTE.toString(), sb);
        } else {
            try {
                byte[] binaryValue = value.binaryValue();
                if (binaryValue.length > 1) {
                    valid = false;
                    StringBuffer sbInner = this.getNewStringBuffer(sb);
                    sbInner.append(" is a bynary but is longer than a byte (i.e. 8 bits)");
                    this.addError(sbInner);
                }
            }
            catch (IOException e) {
                valid = false;
                StringBuffer sbInner = this.getNewStringBuffer(sb);
                sbInner.append("' is not a byte");
                this.addError(sbInner);
            }
        }
        return valid;
    }

    protected StringBuffer getPropertyStringBuffer(StringBuffer sb, String expectedPropertyType, boolean fromMultipleInstaces) {
        StringBuffer sbInner = this.getNewStringBuffer(sb);
        if (fromMultipleInstaces) {
            sbInner.append(" has one instance that is not a '").append(expectedPropertyType).append("'");
        } else {
            sbInner.append(" is not a '").append(expectedPropertyType).append("'");
        }
        return sbInner;
    }

    protected boolean checkPropertyTypeCompliance(JsonNode value, String expectedPropertyType, StringBuffer sb, boolean fromMultipleInstaces) {
        boolean valid = true;
        if (!value.isObject() || !value.has("type")) {
            valid = false;
            StringBuffer sbInner = this.getPropertyStringBuffer(sb, expectedPropertyType, fromMultipleInstaces);
            this.addError(sbInner);
            return valid;
        }
        try {
            Property p = (Property)ElementMapper.getObjectMapper().treeToValue((TreeNode)value, Property.class);
            StringBuffer log = new StringBuffer();
            if (fromMultipleInstaces) {
                log.append("For ");
                log.append(this.getNewStringBuffer(sb));
                log.append(" one of the instances is '");
            } else {
                log.append(this.getNewStringBuffer(sb));
                log.append(" is ");
            }
            TypesKnowledge tk = TypesKnowledge.getInstance();
            Tree<Type> tree = tk.getModelKnowledge().getTree(AccessType.PROPERTY);
            if (expectedPropertyType.compareTo(p.getTypeName()) == 0) {
                log.append(expectedPropertyType);
                log.append("' as expected.");
                logger.trace(log.toString());
            } else if (tree.isChildOf(expectedPropertyType, p.getTypeName())) {
                log.append(p.getTypeName());
                log.append("' that is a subclass of '");
                log.append(expectedPropertyType);
                log.append("' and this is totally fine.");
                logger.trace(log.toString());
            } else if (tree.isParentOf(expectedPropertyType, p.getTypeName()) && expectedPropertyType.compareTo(p.getExpectedtype()) == 0) {
                log.append(expectedPropertyType);
                log.append("' as expected. Jackson used the best supertype available in the classpath i.e. '");
                log.append(p.getTypeName());
                log.append("' to instatiate it.");
                logger.trace(log.toString());
            } else {
                valid = false;
                StringBuffer sbInner = this.getPropertyStringBuffer(sb, expectedPropertyType, fromMultipleInstaces);
                this.addError(sbInner);
            }
        }
        catch (JsonProcessingException e) {
            valid = false;
            StringBuffer sbInner = this.getPropertyStringBuffer(sb, expectedPropertyType, fromMultipleInstaces);
            this.addError(sbInner);
        }
        return valid;
    }

    private boolean checkArrayOrSet(JsonNode value, String expectedType) {
        StringBuffer sbInner;
        boolean valid = true;
        Integer max = this.attributeDefinition.getMax();
        Integer min = this.attributeDefinition.getMin();
        ArrayNode arrayNode = (ArrayNode)value;
        if (min != null && arrayNode.size() < min) {
            valid = false;
            sbInner = this.getNewStringBuffer(null);
            sbInner.append(" contains less than the minimum number of elements").append(min);
            this.addError(sbInner);
            if (this.stopOnError) {
                return valid;
            }
        }
        if (max != null && arrayNode.size() > max) {
            valid = false;
            sbInner = this.getNewStringBuffer(null);
            sbInner.append(" contains more than the maximum number of elements ").append(max);
            this.addError(sbInner);
            if (this.stopOnError) {
                return valid;
            }
        }
        PropertyTypeName pt = new PropertyTypeName(expectedType);
        PropertyTypeName.BaseType genericBaseType = pt.getGenericBaseType();
        String expectedPropertyType = pt.getGenericClassName();
        if (expectedPropertyType == null) {
            expectedPropertyType = genericBaseType.toString();
        }
        for (JsonNode element : arrayNode) {
            valid = this.validate(expectedPropertyType, element, this.getNewStringBuffer(null)) && valid;
            if (valid || !this.stopOnError) continue;
            return valid;
        }
        return valid;
    }

    protected boolean validate(String expectedType, JsonNode value, StringBuffer sb) {
        boolean valid = true;
        PropertyTypeName pt = new PropertyTypeName(expectedType);
        PropertyTypeName.BaseType baseType = pt.getBaseType();
        boolean entry = false;
        if (sb == null) {
            entry = true;
        }
        switch (baseType) {
            case ANY: {
                break;
            }
            case BOOLEAN: {
                if (value.isBoolean()) break;
                valid = this.typeNotCompliant(value, expectedType, sb);
                break;
            }
            case INTEGER: {
                if (!value.isInt()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                Integer intValue = value.asInt();
                valid = this.validateNumber(intValue, sb) && valid;
                break;
            }
            case SHORT: {
                if (!value.isShort()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                Short shortValue = value.shortValue();
                valid = this.validateNumber(shortValue, sb) && valid;
                break;
            }
            case LONG: {
                if (!value.isLong()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                Long longValue = value.asLong();
                valid = this.validateNumber(longValue, sb) && valid;
                break;
            }
            case FLOAT: {
                if (!value.isFloat()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                Float floatValue = Float.valueOf(value.floatValue());
                valid = this.validateNumber(floatValue, sb) && valid;
                break;
            }
            case DOUBLE: {
                if (!value.isDouble()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                Double doubleValue = value.asDouble();
                valid = this.validateNumber(doubleValue, sb) && valid;
                break;
            }
            case DATE: {
                valid = this.validateDate(value, sb) && valid;
                break;
            }
            case STRING: {
                valid = this.validateString(value, sb) && valid;
                break;
            }
            case BINARY: {
                if (value.isBinary()) break;
                valid = this.typeNotCompliant(value, expectedType, sb);
                break;
            }
            case BYTE: {
                valid = this.validateByte(value, sb) && valid;
                break;
            }
            case JSON_OBJECT: {
                if (value.isObject()) break;
                valid = this.typeNotCompliant(value, expectedType, sb);
                break;
            }
            case JSON_ARRAY: {
                if (value.isArray()) break;
                valid = this.typeNotCompliant(value, expectedType, sb);
                break;
            }
            case PROPERTY: {
                valid = this.checkPropertyTypeCompliance(value, expectedType, sb, false) && valid;
                break;
            }
            case LIST: 
            case SET: {
                if (!entry) {
                    StringBuffer sbInner = this.getNewStringBuffer(null);
                    sbInner.append(" has nested ").append(baseType.toString().toLowerCase());
                    sbInner.append(" and this is not allowed.");
                    this.addError(sb);
                    valid = false;
                    break;
                }
                if (!value.isArray()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                this.checkArrayOrSet(value, expectedType);
                break;
            }
            case MAP: {
                if (!entry) {
                    StringBuffer sbInner = this.getNewStringBuffer(null);
                    sbInner.append(" has nested ").append(baseType.toString().toLowerCase());
                    sbInner.append(" and this is not allowed.");
                    this.addError(sbInner);
                    valid = false;
                    break;
                }
                if (!value.isObject()) {
                    valid = this.typeNotCompliant(value, expectedType, sb);
                    break;
                }
                ObjectNode objectNode = (ObjectNode)value;
                Iterator iterator = objectNode.elements();
                while (iterator.hasNext()) {
                    JsonNode element = (JsonNode)iterator.next();
                    valid = this.checkPropertyTypeCompliance(element, pt.getGenericClassName(), this.getNewStringBuffer(sb), true) && valid;
                    if (valid || !this.stopOnError) continue;
                    return valid;
                }
                break;
            }
        }
        return valid;
    }

    public boolean validate() {
        boolean valid = true;
        if (this.value != null) {
            if (this.value instanceof NullNode) {
                if (this.attributeDefinition.isNotnull()) {
                    valid = false;
                    StringBuffer sb = this.getNewStringBuffer(null);
                    sb.append(" cannot be null");
                    this.addError(sb);
                }
            } else {
                valid = this.validate(this.attributeDefinition.getPropertyType(), this.value, null);
            }
        } else if (this.attributeDefinition.isMandatory()) {
            valid = false;
            StringBuffer sb = this.getNewStringBuffer(null);
            sb.append(" is mandatory but it is not present in the instance");
            this.addError(sb);
        }
        this.attributeValidatorReport.setValid(valid);
        return valid;
    }
}

