/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.net.URI;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class UriStringConverter
implements Converter<URI, CharSequence> {
    @Override
    public String applyTo(URI uri) {
        Assert.notNull((Object)uri, (String)"URI cannot be null.");
        return uri.toString();
    }

    @Override
    public URI applyFrom(CharSequence s) {
        Assert.hasText((CharSequence)s, (String)"URI string cannot be null or empty.");
        try {
            return URI.create(s.toString());
        }
        catch (Exception e) {
            String msg = "Unable to convert String value '" + s + "' to URI instance: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

