/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherFactory.class);

    public static String getResourceRegistryURL() {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL(), "resource-registry");
        return address;
    }

    public static String getResourceRegistryURL(String context) {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL((String)context), "resource-registry");
        return address;
    }

    public static ResourceRegistryPublisher create() {
        String address = ResourceRegistryPublisherFactory.getResourceRegistryURL();
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryPublisherImpl(address);
    }

    public static ResourceRegistryPublisher create(String context) {
        String address = ResourceRegistryPublisherFactory.getResourceRegistryURL(context);
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryPublisherImpl(address);
    }
}

