/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore.utils;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathHelper {
    private static XPathFactory factory = XPathFactory.newInstance();
    private XPath engine = factory.newXPath();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private NamespaceContext nsContext = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            return XPathHelper.this.namespaces.get(prefix);
        }

        @Override
        public Iterator<String> getPrefixes(String val) {
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }
    };
    private static Transformer transformer;
    private final Node root;

    public XPathHelper(Node root) {
        this.root = root;
        this.engine.setNamespaceContext(this.nsContext);
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public List<String> evaluate(String xpath) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            NodeList set = this.evaluateForNodes(xpath);
            for (int i = 0; i < set.getLength(); ++i) {
                StreamResult sr = new StreamResult(new StringWriter());
                transformer.transform(new DOMSource(set.item(i)), sr);
                results.add(sr.getWriter().toString());
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NodeList evaluateForNodes(String xpath) {
        try {
            return (NodeList)this.engine.evaluate(xpath, this.root, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

