/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.io.IOException;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.utils.JsonUtility;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDUtility {
    private static Logger logger = LoggerFactory.getLogger(UUIDUtility.class);

    public static UUID getUUID(JsonNode jsonNode) {
        JsonNode jsonNodeID;
        if (jsonNode.has("id") && (jsonNodeID = jsonNode.get("id")) != null && jsonNodeID.isTextual()) {
            return UUID.fromString(jsonNodeID.asText());
        }
        return null;
    }

    public static UUID getUUID(String json) throws JsonProcessingException, IOException {
        logger.trace("Trying to get UUID of {} ", (Object)json);
        JsonNode jsonNode = JsonUtility.getJsonNode(json);
        return UUIDUtility.getUUID(jsonNode);
    }

    public static String getUUIDAsString(JsonNode jsonNode) {
        UUID uuid = UUIDUtility.getUUID(jsonNode);
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }

    public static String getUUIDAsString(String json) throws JsonProcessingException, IOException {
        return UUIDUtility.getUUID(json).toString();
    }

    public static UUID fromString(String uuidString) throws Exception {
        UUID uuid = UUID.fromString(uuidString);
        UUIDManager.getInstance().validateUUID(uuid);
        return uuid;
    }
}

