/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.tree;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.gcube.informationsystem.tree.NodeElaborator;
import org.gcube.informationsystem.tree.NodeInformation;
import org.gcube.informationsystem.tree.Tree;

public class Node<T>
implements Comparable<Node<T>> {
    public static String INDENTATION = "\t";
    protected T t;
    protected Tree<T> tree;
    protected Set<T> childrenElements;
    protected Set<T> descendantElements;
    protected Node<T> parent;
    protected Set<Node<T>> children;
    protected Set<Node<T>> descendants;

    public Node(T t) {
        this.t = t;
        this.children = new TreeSet<Node<T>>();
    }

    public Tree<T> getTree() {
        return this.tree;
    }

    void setTree(Tree<T> tree) {
        this.tree = tree;
    }

    public T getNodeElement() {
        return this.t;
    }

    public Node<T> getParent() {
        return this.parent;
    }

    public Node<T> setParent(Node<T> parent) {
        this.parent = parent;
        return this;
    }

    public Node<T> addChild(Node<T> child) {
        this.children.add(child);
        child.setParent(this);
        child.setTree(this.tree);
        return this;
    }

    public String getIdentifier() {
        return this.tree.getNodeInformation().getIdentifier(this.t);
    }

    public Set<Node<T>> getChildren() {
        return this.children;
    }

    public Set<Node<T>> getDescendants() {
        if (this.descendants == null) {
            this.descendants = new TreeSet<Node<T>>();
            for (Node<T> child : this.children) {
                this.descendants.add(child);
                this.descendants.addAll(child.getDescendants());
            }
        }
        return this.descendants;
    }

    public Set<T> getChildrenElements() {
        if (this.childrenElements == null) {
            final NodeInformation<T> ni = this.tree.getNodeInformation();
            this.childrenElements = new TreeSet<T>(new Comparator<T>(){

                @Override
                public int compare(T t1, T t2) {
                    return ni.getIdentifier(t1).compareTo(ni.getIdentifier(t2));
                }
            });
            for (Node<T> child : this.children) {
                this.childrenElements.add(child.t);
            }
        }
        return this.childrenElements;
    }

    public Set<T> getDescendantElements() {
        if (this.descendantElements == null) {
            this.descendantElements = new TreeSet<T>(new Comparator<T>(){

                @Override
                public int compare(T t1, T t2) {
                    NodeInformation ni = Node.this.tree.getNodeInformation();
                    return ni.getIdentifier(t1).compareTo(ni.getIdentifier(t2));
                }
            });
            for (Node<T> child : this.children) {
                this.descendantElements.add(child.t);
                this.descendantElements.addAll(child.getDescendantElements());
            }
        }
        return this.descendantElements;
    }

    public String toString() {
        return this.printTree(0).toString();
    }

    private StringBuffer printTree(int level) {
        final StringBuffer stringBuffer = new StringBuffer();
        NodeElaborator nodeElaborator = new NodeElaborator<T>(){

            @Override
            public void elaborate(Node<T> node, int level) throws Exception {
                for (int i = 0; i < level; ++i) {
                    stringBuffer.append(INDENTATION);
                }
                stringBuffer.append(Node.this.tree.getNodeInformation().getIdentifier(node.getNodeElement()));
                stringBuffer.append("\n");
            }
        };
        try {
            this.elaborate(nodeElaborator, level);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stringBuffer;
    }

    @Override
    public int compareTo(Node<T> other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (this.getClass() != other.getClass()) {
            return -1;
        }
        return this.getIdentifier().compareTo(other.getIdentifier());
    }

    public void elaborate(NodeElaborator<T> nodeElaborator) throws Exception {
        this.elaborate(nodeElaborator, 0);
    }

    protected void elaborate(NodeElaborator<T> nodeElaborator, int level) throws Exception {
        nodeElaborator.elaborate(this, level);
        for (Node<T> child : this.children) {
            child.elaborate(nodeElaborator, level + 1);
        }
    }
}

