/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.InputStream;
import org.gcube.io.jsonwebtoken.impl.io.FilteredInputStream;
import org.gcube.io.jsonwebtoken.io.DecodingException;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class DecodingInputStream
extends FilteredInputStream {
    private final String codecName;
    private final String name;

    public DecodingInputStream(InputStream in, String codecName, String name) {
        super(in);
        this.codecName = (String)Assert.hasText((CharSequence)codecName, (String)"codecName cannot be null or empty.");
        this.name = (String)Assert.hasText((CharSequence)name, (String)"Name cannot be null or empty.");
    }

    @Override
    protected void onThrowable(Throwable t) {
        String msg = "Unable to " + this.codecName + "-decode " + this.name + ": " + t.getMessage();
        throw new DecodingException(msg, t);
    }
}

