/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.client.queries.impl;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.client.queries.impl.Utils;

public class QueryTemplate
extends QueryBox
implements Query {
    public static final String DEFAULT = "def";
    private static final XMLInputFactory xmlif = XMLInputFactory.newInstance();
    private static final String wrapper = "_template_";
    private final Map<String, String> parameters;

    public QueryTemplate(String template) {
        super(template);
        this.parameters = new HashMap<String, String>();
    }

    public QueryTemplate(String template, Map<String, String> parameters) {
        super(template);
        Utils.notNull("parameters", parameters);
        this.parameters = new HashMap<String, String>(parameters);
    }

    @Override
    public String expression() {
        return this.interpolate(super.expression(), this.parameters);
    }

    public void addParameter(String name, String value) {
        Utils.notNull("name", name);
        Utils.notNull("value", value);
        this.parameters.put(name, value);
    }

    public void appendParameter(String name, String value) {
        Utils.notNull("name", name);
        Utils.notNull("value", value);
        if (this.parameters.containsKey(name)) {
            value = this.parameters.get(name) + (String)value;
        }
        this.parameters.put(name, (String)value);
    }

    public String parameter(String name) throws IllegalStateException {
        Utils.notNull("name", name);
        if (this.hasParameter(name)) {
            return this.parameters.get(name);
        }
        throw new IllegalStateException("unknown parameter " + name);
    }

    public boolean hasParameter(String name) {
        Utils.notNull("name", name);
        return this.parameters.containsKey(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String interpolate(String expression, Map<String, String> parameters) {
        try {
            StringBuilder builder = new StringBuilder();
            XMLStreamReader xmlr = xmlif.createXMLStreamReader(new StringReader("<_template_>" + expression + "</_template_>"));
            while (true) {
                int tokenType = xmlr.next();
                switch (tokenType) {
                    case 1: {
                        String name = xmlr.getLocalName();
                        if (name.equals(wrapper)) break;
                        if (parameters.containsKey(name)) {
                            builder.append(parameters.get(name));
                            break;
                        }
                        String def = xmlr.getAttributeValue(null, DEFAULT);
                        if (def == null) break;
                        builder.append(def);
                        break;
                    }
                    case 4: {
                        builder.append(xmlr.getText());
                        break;
                    }
                    case 8: {
                        return builder.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cannot replace parameters " + parameters + " in query " + expression, e);
        }
    }
}

