/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.NodeElaborator;
import org.gcube.informationsystem.tree.NodeInformation;

public class Tree<T> {
    private boolean allowMultipleInheritance = true;
    private Node<T> rootNode;
    private NodeInformation<T> ni;
    private Map<String, Node<T>> locate = new HashMap<String, Node<T>>();

    public Tree() {
    }

    public Tree(NodeInformation<T> ni) {
        this();
        this.setNodeInformation(ni);
    }

    public Tree(T root, NodeInformation<T> ni) {
        this(ni);
        this.setRoot(root);
    }

    public void setNodeInformation(NodeInformation<T> ni) {
        if (this.ni == null) {
            this.ni = ni;
        }
    }

    public void setRoot(T root) throws RuntimeException {
        if (this.ni == null) {
            throw new RuntimeException("You must set the NodeInformation instance first");
        }
        if (this.rootNode == null) {
            this.rootNode = new Node<T>(root);
            this.rootNode.setTree(this);
            String identifier = this.ni.getIdentifier(root);
            this.locate.put(identifier, this.rootNode);
        }
    }

    public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
        this.allowMultipleInheritance = allowMultipleInheritance;
    }

    public NodeInformation<T> getNodeInformation() {
        return this.ni;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node<T> addNode(T t) {
        String identifier = this.ni.getIdentifier(t);
        if (this.locate.containsKey(identifier)) {
            return this.locate.get(identifier);
        }
        Node<T> node = new Node<T>(t);
        node.setTree(this);
        Set<String> parentIdentifiers = this.ni.getParentIdentifiers(this.rootNode != null ? (Object)this.rootNode.getNodeElement() : null, t);
        if (parentIdentifiers == null || parentIdentifiers.size() == 0) {
            if (this.rootNode != null) throw new RuntimeException("A Tree cannot have two root. " + t.toString() + " has not parent.");
            this.rootNode = node;
        } else {
            for (String parentIdentifier : parentIdentifiers) {
                Node<T> parentNode = this.locate.get(parentIdentifier);
                if (parentNode == null) {
                    throw new RuntimeException("I can find parent for " + identifier + ". Missing parent is " + parentIdentifier);
                }
                parentNode.addChild(node);
                if (this.allowMultipleInheritance) continue;
                break;
            }
        }
        this.locate.put(identifier, node);
        return node;
    }

    public Node<T> getRootNode() {
        return this.rootNode;
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public void elaborate(NodeElaborator<T> nodeElaborator) throws Exception {
        this.rootNode.elaborate(nodeElaborator);
    }

    public Node<T> getNodeByIdentifier(String identifier) {
        return this.locate.get(identifier);
    }
}

