/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.connector.resourceregistry;

import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.smartgears.configuration.AuthorizationProviderConfiguration;
import org.gcube.smartgears.connector.resourceregistry.Constants;
import org.gcube.smartgears.connector.resourceregistry.ContextUtility;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.EServiceManager;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.gcube.smartgears.security.AuthorizationProvider;
import org.gcube.smartgears.security.AuthorizationProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmartgearsProfilePublisher
public class FacetBasedPublisher
implements Publisher {
    private static Logger logger = LoggerFactory.getLogger(FacetBasedPublisher.class);
    protected ResourceRegistryPublisher resourceRegistryPublisher;

    public static AuthorizationProvider getAuthorizationProvider(ApplicationContext applicationContext) {
        return FacetBasedPublisher.getAuthorizationProvider(applicationContext.container());
    }

    public static AuthorizationProvider getAuthorizationProvider(ContainerContext containerContext) {
        AuthorizationProviderConfiguration authorizationProviderConfiguration = containerContext.configuration().authorizationConfiguration();
        AuthorizationProviderFactory authorizationProviderFactory = authorizationProviderConfiguration.getAuthProviderFactory();
        AuthorizationProvider authorizationProvider = authorizationProviderFactory.connect(authorizationProviderConfiguration.getCredentials());
        return authorizationProvider;
    }

    public boolean create(ContainerContext containerContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                if (this.resourceRegistryPublisher == null) {
                    this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                }
                HostingNodeManager hostingNodeManager = null;
                for (String c : contextToIterate) {
                    try {
                        if (context.compareTo(c) == 0) {
                            hostingNodeManager = new HostingNodeManager(containerContext, this.resourceRegistryPublisher);
                            hostingNodeManager.createHostingNode();
                            Property property = new Property(Constants.HOSTING_NODE_MANAGER_PROPERTY, (Object)hostingNodeManager);
                            containerContext.properties().add(new Property[]{property});
                            continue;
                        }
                        UUID contextUUID = ContextUtility.getContextUUID(context);
                        hostingNodeManager.addToContext(contextUUID, context);
                    }
                    catch (Throwable e) {
                        logger.error("Error while publishing {} (id='{}') in context '{}'", new Object[]{"HostingNode", containerContext.id(), context, e});
                    }
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while publishing {} (id='{}')", new Object[]{"HostingNode", containerContext.id(), e});
        }
        return true;
    }

    public boolean create(ApplicationContext applicationContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                if (this.resourceRegistryPublisher == null) {
                    this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                }
                EServiceManager eServiceManager = null;
                for (String c : contextToIterate) {
                    try {
                        if (context.compareTo(c) == 0) {
                            eServiceManager = new EServiceManager(applicationContext, this.resourceRegistryPublisher);
                            eServiceManager.createEService();
                            Property property = new Property(Constants.ESERVICE_MANAGER_PROPERTY, (Object)eServiceManager);
                            applicationContext.properties().add(new Property[]{property});
                            continue;
                        }
                        UUID contextUUID = ContextUtility.getContextUUID(context);
                        eServiceManager.addToContext(contextUUID, context);
                    }
                    catch (Throwable e) {
                        logger.error("Error while publishing {} (name='{}', id='{}') in context '{}'", new Object[]{"EService", applicationContext.name(), applicationContext.id(), context, e});
                    }
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while publishing {} (name='{}', id='{}')", new Object[]{"EService", applicationContext.name(), applicationContext.id(), e});
        }
        return true;
    }

    public boolean remove(ContainerContext containerContext, Set<String> contexts) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)containerContext.properties().lookup(Constants.HOSTING_NODE_MANAGER_PROPERTY).value();
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        for (String context : contexts) {
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        hostingNodeManager.removeFromCurrentContext();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)authorizationProvider.getSecretForContext(context));
            }
            catch (Throwable e) {
                logger.error("Unable to remove {} (id='{}') from context '{}'", new Object[]{"HostingNode", containerContext.id(), context, e});
            }
        }
        return false;
    }

    public boolean remove(ApplicationContext applicationContext, Set<String> contexts) {
        EServiceManager eServiceManager = (EServiceManager)applicationContext.properties().lookup(Constants.ESERVICE_MANAGER_PROPERTY).value();
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        for (String context : contexts) {
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        eServiceManager.removeFromCurrentContext();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)authorizationProvider.getSecretForContext(context));
            }
            catch (Throwable e) {
                logger.error("Unable to remove {} (name='{}', id='{}') from context '{}'", new Object[]{"EService", applicationContext.name(), applicationContext.id(), context, e});
            }
        }
        return true;
    }

    public boolean update(ContainerContext containerContext) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)containerContext.properties().lookup(Constants.HOSTING_NODE_MANAGER_PROPERTY).value();
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    hostingNodeManager.updateFacets();
                }
                catch (ResourceRegistryException e) {
                    throw new RuntimeException(e);
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Unable to update {} (id='{}')", new Object[]{"HostingNode", containerContext.id(), e});
        }
        return true;
    }

    public boolean update(ApplicationContext applicationContext) {
        EServiceManager eServiceManager = (EServiceManager)applicationContext.properties().lookup(Constants.ESERVICE_MANAGER_PROPERTY).value();
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    eServiceManager.updateFacets();
                }
                catch (ResourceRegistryException e) {
                    throw new RuntimeException(e);
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Unable to update {} (name='{}', id='{}') ", new Object[]{"EService", applicationContext.name(), applicationContext.id(), e});
        }
        return true;
    }
}

