/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.PolicyUtils;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.User2ServicePolicy;
import org.gcube.common.authorization.library.policies.UserEntity;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.ServiceIdentifier;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-validation")
public class RequestValidator
extends RequestHandler {
    @XmlAttribute(required=false, name="oauth")
    @Deprecated
    boolean oauthCompatibility = false;
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext context;

    @Override
    public String getName() {
        return "request-validation";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        log.trace("executing request validator ON REQUEST");
        log.trace("accessToken is null? {} \nGcubeToken is null ? {} \nscope rpvideris null? {}", new Object[]{AccessTokenProvider.instance.get() == null, SecurityTokenProvider.instance.get() == null, ScopeProvider.instance.get() == null});
        this.context = (ApplicationContext)call.context();
        this.validateAgainstLifecycle(call);
        this.rejectUnauthorizedCalls(call);
        if (this.context.container().configuration().mode() != Mode.offline) {
            this.validateScopeCall();
            this.validatePolicy(ScopeProvider.instance.get(), call);
        }
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.context.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScopeCall() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            log.warn("rejecting unscoped call to {}", (Object)this.context.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        ScopeBean bean = new ScopeBean(scope);
        ContainerConfiguration conf = this.context.container().configuration();
        if (!(conf.allowedContexts().contains(scope) || conf.authorizeChildrenContext() && bean.is(ScopeBean.Type.VRE) && conf.allowedContexts().contains(bean.enclosingScope().toString()))) {
            log.warn("rejecting call to {} in invalid context {}, allowed context are {}", new Object[]{this.context.name(), scope, this.context.container().configuration().allowedContexts()});
            RequestError.invalid_request_error.fire(this.context.name() + " cannot be called in scope " + scope);
        }
    }

    private void rejectUnauthorizedCalls(RequestEvent call) {
        String token = SecurityTokenProvider.instance.get();
        String accessToken = AccessTokenProvider.instance.get();
        if (token == null && accessToken == null) {
            log.warn("rejecting call to {}, authorization required", (Object)this.context.name(), (Object)token);
            RequestError.request_not_authorized_error.fire(this.context.name() + ": authorization required");
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePolicy(String scope, RequestEvent call) {
        log.info("accessing policy validator in scope {} ", (Object)scope);
        ServiceIdentifier serviceIdentifier = Utils.getServiceInfo((ApplicationContext)call.context()).getServiceIdentifier();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            String serviceToken = (String)this.context.configuration().startTokens().stream().findFirst().get();
            SecurityTokenProvider.instance.set(serviceToken);
            String callerId = AuthorizationProvider.instance.get().getClient().getId();
            List policies = Collections.emptyList();
            try {
                policies = Constants.authorizationService().getPolicies(scope);
            }
            catch (Exception e) {
                log.error("error contacting authorization services for policies");
            }
            for (Policy policy : policies) {
                log.debug("policy: {}", (Object)policy.getPolicyAsString());
                if (!PolicyUtils.isPolicyValidForClient((ServiceAccess)policy.getServiceAccess(), (ServiceIdentifier)serviceIdentifier)) continue;
                boolean toReject = false;
                UserEntity entity = ((User2ServicePolicy)policy).getEntity();
                if (entity.getIdentifier() != null) {
                    toReject = entity.getIdentifier().equals(callerId);
                } else if (entity.getExcludes().isEmpty()) {
                    toReject = true;
                } else {
                    boolean bl = toReject = !entity.getExcludes().contains(callerId);
                }
                if (!toReject) continue;
                log.error("rejecting call to {} : {} is not allowed to contact the service ", (Object)this.context.name(), (Object)callerId);
                RequestError.request_not_authorized_error.fire("rejecting call to " + this.context.name() + " for polices: " + callerId + " is not allowed to contact the service: " + serviceIdentifier.getServiceName());
            }
        }
        finally {
            SecurityTokenProvider.instance.set(previousToken);
        }
    }
}

