/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery.knowledge;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.Discovery;
import org.gcube.informationsystem.discovery.RegistrationProvider;
import org.gcube.informationsystem.discovery.knowledge.ModelKnowledge;
import org.gcube.informationsystem.discovery.knowledge.ModelKnowledgeValidator;
import org.gcube.informationsystem.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Knowledge {
    public static Logger logger = LoggerFactory.getLogger(Knowledge.class);
    private static Knowledge instance;
    protected ModelKnowledge allKnowledge;
    protected Map<String, ModelKnowledge> modelKnowledges;
    protected Map<String, RegistrationProvider> registrationProviders;

    public static Knowledge getInstance() throws Exception {
        return Knowledge.getInstance(false);
    }

    public static Knowledge getInstance(boolean forceRediscover) throws Exception {
        if (forceRediscover) {
            instance = null;
        }
        if (instance == null) {
            instance = new Knowledge();
            instance.discover();
        }
        return instance;
    }

    private Knowledge() {
    }

    public ModelKnowledge getAllKnowledge() {
        return this.allKnowledge;
    }

    public ModelKnowledge getModelKnowledge(RegistrationProvider rp) {
        return this.modelKnowledges.get(rp.getModelName());
    }

    public ModelKnowledge getModelKnowledge(String modelName) {
        return this.modelKnowledges.get(modelName);
    }

    public void validateModelKnowledge(RegistrationProvider rp) throws Exception {
        AccessType[] accessTypes;
        ModelKnowledge modelKnowledge = this.getModelKnowledge(rp);
        ModelKnowledgeValidator ra = new ModelKnowledgeValidator(rp);
        for (AccessType accessType : accessTypes = AccessType.getModelTypes()) {
            logger.trace("Going to analise discovered types of '{}' for model '{}'", (Object)accessType.getName(), (Object)rp.getModelName());
            Discovery<Element> discovery = modelKnowledge.getDiscovery(accessType);
            discovery.executeDiscoveredElementActions(ra);
            logger.trace("Going to analise tree of '{}' type for model '{}'", (Object)accessType.getName(), (Object)rp.getModelName());
            Tree<Class<Element>> tree = modelKnowledge.getClassesTree(accessType);
            tree.elaborate(ra);
        }
    }

    public void validateModelKnowledge(String modelName) throws Exception {
        RegistrationProvider rp = this.registrationProviders.get(modelName);
        this.validateModelKnowledge(rp);
    }

    public void discover() throws Exception {
        this.allKnowledge = new ModelKnowledge();
        this.modelKnowledges = new LinkedHashMap<String, ModelKnowledge>();
        this.registrationProviders = new LinkedHashMap<String, RegistrationProvider>();
        ServiceLoader<RegistrationProvider> providers = ServiceLoader.load(RegistrationProvider.class);
        for (RegistrationProvider rp : providers) {
            this.registrationProviders.put(rp.getModelName(), rp);
            ModelKnowledge modelKnowledge = new ModelKnowledge();
            this.modelKnowledges.put(rp.getModelName(), modelKnowledge);
            modelKnowledge.addPackages(rp.getPackagesToRegister());
            modelKnowledge.createKnowledge();
            this.allKnowledge.addPackages(rp.getPackagesToRegister());
        }
        this.allKnowledge.createKnowledge();
    }
}

