/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.secret;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.authorization.utils.clientid.RenewalProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.user.KeycloakUser;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.RefreshToken;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.keycloak.model.util.Time;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTSecret
extends Secret {
    private static final Logger logger = LoggerFactory.getLogger(JWTSecret.class);
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    protected AccessToken accessToken;
    protected TokenResponse tokenResponse;
    protected RenewalProvider renewalProvider;
    protected Set<String> roles;
    protected ClientInfo clientInfo;
    protected Caller caller;
    protected String context;

    public JWTSecret(String token) {
        super(10, token);
    }

    private String getTokenString() {
        try {
            boolean expired = false;
            this.getAccessToken();
            if (Time.currentTimeMillis() >= this.accessToken.getExp() - TOLERANCE) {
                expired = true;
                if (this.tokenResponse != null) {
                    try {
                        KeycloakClientFactory.newInstance().refreshToken(this.getUsername(), this.tokenResponse);
                        expired = false;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to refresh the token with RefreshToken. Going to try to renew it if possible.", (Throwable)e);
                    }
                }
            }
            if (expired && this.renewalProvider != null) {
                try {
                    JWTSecret renewed = (JWTSecret)this.renewalProvider.renew();
                    this.token = renewed.token;
                    this.accessToken = this.getAccessToken();
                }
                catch (Exception e) {
                    logger.warn("Unable to renew the token with the RenewalProvider. I'll continue using the old token.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error in the procedure to evaluate/refresh the current token. I'll continue using the old token.", (Throwable)e);
        }
        return this.token;
    }

    @Override
    public void setToken() throws Exception {
        AccessTokenProvider.instance.set(this.getTokenString());
    }

    @Override
    public void resetToken() throws Exception {
        AccessTokenProvider.instance.reset();
    }

    protected AccessToken getAccessToken() throws Exception {
        if (this.accessToken == null) {
            String realUmaTokenEncoded = this.token.split("\\.")[1];
            String realUmaToken = new String(Base64.getDecoder().decode(realUmaTokenEncoded.getBytes()));
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.accessToken = (AccessToken)mapper.readValue(realUmaToken, AccessToken.class);
            }
            catch (Exception e) {
                logger.error("Error parsing JWT token", (Throwable)e);
                throw new Exception("Error parsing JWT token", e);
            }
        }
        return this.accessToken;
    }

    protected Set<String> getRoles() throws Exception {
        if (this.roles == null) {
            String context;
            Map accesses = this.getAccessToken().getResourceAccess();
            AccessToken.Access access = (AccessToken.Access)accesses.get(URLEncoder.encode(context = this.getContext(), StandardCharsets.UTF_8.toString()));
            this.roles = access != null ? access.getRoles() : new HashSet<String>();
        }
        return this.roles;
    }

    @Override
    public ClientInfo getClientInfo() throws Exception {
        if (this.clientInfo == null) {
            this.getAccessToken();
            ArrayList<String> roles = new ArrayList<String>(this.getRoles());
            this.clientInfo = new UserInfo(this.accessToken.getPreferredUsername(), roles, this.accessToken.getEmail(), this.accessToken.getGivenName(), this.accessToken.getFamilyName());
        }
        return this.clientInfo;
    }

    @Override
    public Caller getCaller() throws Exception {
        if (this.caller == null) {
            this.caller = new Caller(this.getClientInfo(), "token");
        }
        return this.caller;
    }

    @Override
    public String getContext() throws Exception {
        if (this.context == null) {
            String[] audience;
            for (String aud : audience = this.getAccessToken().getAudience()) {
                if (aud == null || aud.compareTo("") == 0) continue;
                try {
                    String contextToBeValidated = URLDecoder.decode(aud, StandardCharsets.UTF_8.toString());
                    ScopeBean scopeBean = new ScopeBean(contextToBeValidated);
                    this.context = scopeBean.toString();
                    return this.context;
                }
                catch (Exception e) {
                    logger.error("Invalid context name for audience {} in access token. Trying next one if any.", (Object)aud, (Object)e);
                }
            }
            throw new Exception("Invalid context in access token");
        }
        return this.context;
    }

    @Override
    public String getUsername() throws Exception {
        return this.accessToken.getPreferredUsername();
    }

    @Override
    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("Authorization", "Bearer " + this.getTokenString());
        return authorizationHeaders;
    }

    public void setRenewalProvider(RenewalProvider renewalProvider) {
        this.renewalProvider = renewalProvider;
    }

    public void setTokenResponse(TokenResponse tokenResponse) {
        this.tokenResponse = tokenResponse;
    }

    protected boolean isExpired(AccessToken accessToken) {
        return Time.currentTimeMillis() > accessToken.getExp();
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(this.accessToken);
    }

    @Override
    public boolean isRefreshable() {
        if (this.tokenResponse != null) {
            try {
                RefreshToken refreshToken = ModelUtils.getRefreshTokenFrom((TokenResponse)this.tokenResponse);
                return this.isExpired((AccessToken)refreshToken);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public User getUser() {
        if (this.user == null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String accessTokenString = objectMapper.writeValueAsString((Object)this.accessToken);
                this.user = (User)objectMapper.readValue(accessTokenString, KeycloakUser.class);
                this.user.setRoles(this.getRoles());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
        return this.user;
    }
}

