/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.annotations.Abstract;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeImpl;
import org.gcube.informationsystem.types.impl.relations.RelationTypeImpl;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeImpl
implements org.gcube.informationsystem.types.reference.Type {
    private static Logger logger = LoggerFactory.getLogger(TypeImpl.class);
    private static final long serialVersionUID = -4333954207969059451L;
    public static final String DESCRIPTION = "DESCRIPTION";
    protected Header header;
    protected String name;
    protected String description;
    @JsonProperty(value="abstract")
    protected boolean abstractType;
    protected Set<String> superClasses;
    protected Set<PropertyDefinition> properties;

    protected <E extends Element> Set<String> retrieveSuperClasses(Class<? extends E> type, Class<E> baseClass, String topSuperClass) {
        Class<?>[] interfaces;
        HashSet<String> interfaceList = new HashSet<String>();
        if (type == baseClass) {
            if (topSuperClass != null) {
                interfaceList.add(topSuperClass);
            }
            return interfaceList;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            if (!baseClass.isAssignableFrom(interfaceClass)) continue;
            Class<?> clz = interfaceClass;
            interfaceList.add(TypeMapper.getType(clz));
        }
        return interfaceList;
    }

    protected Set<PropertyDefinition> retrieveListOfProperties(Class<?> type) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        for (Method m : type.getDeclaredMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(ISProperty.class) || m.isBridge()) continue;
            ISProperty propAnnotation = m.getAnnotation(ISProperty.class);
            PropertyDefinitionImpl prop = new PropertyDefinitionImpl(propAnnotation, m);
            properties.add(prop);
            logger.trace("Property {} retrieved in type {} ", (Object)prop, (Object)type.getSimpleName());
        }
        return properties;
    }

    protected Class<?> getGenericClass(Type type) {
        TypeVariable typeVariable = (TypeVariable)type;
        Type[] bounds = typeVariable.getBounds();
        Type t = bounds[0];
        if (t instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)t;
            return (Class)parameterizedType.getRawType();
        }
        return (Class)t;
    }

    public static org.gcube.informationsystem.types.reference.Type getInstance(Class<? extends Element> clz) {
        org.gcube.informationsystem.types.reference.Type typeDefinition = null;
        try {
            if (EntityElement.class.isAssignableFrom(clz)) {
                EntityType entityType = typeDefinition = EntityTypeImpl.getEntityTypeDefinitionInstance(clz);
                return entityType;
            }
            if (RelationElement.class.isAssignableFrom(clz)) {
                org.gcube.informationsystem.types.reference.Type type = typeDefinition = RelationTypeImpl.getRelationTypeDefinitionInstance(clz);
                return type;
            }
            if (PropertyElement.class.isAssignableFrom(clz)) {
                org.gcube.informationsystem.types.reference.Type type = typeDefinition = new PropertyTypeImpl<Element>(clz);
                return type;
            }
            if (org.gcube.informationsystem.types.reference.Type.class.isAssignableFrom(clz)) {
                org.gcube.informationsystem.types.reference.Type type = typeDefinition = new TypeImpl(clz);
                return type;
            }
            throw new RuntimeException("Serialization required");
        }
        finally {
            if (typeDefinition != null) {
                logger.debug("{} : {} ", clz, (Object)typeDefinition);
            }
        }
    }

    protected TypeImpl() {
    }

    protected TypeImpl(Class<? extends Element> clz) {
        this.name = TypeMapper.getType(clz);
        this.description = TypeMapper.getStaticStringFieldByName(clz, DESCRIPTION, "");
        this.abstractType = false;
        if (clz.isAnnotationPresent(Abstract.class)) {
            this.abstractType = true;
        }
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isAbstract() {
        return this.abstractType;
    }

    @Override
    public Set<String> getSuperClasses() {
        return this.superClasses;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Set<PropertyDefinition> getProperties() {
        return this.properties;
    }
}

