/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GcubeJwt {
    protected static final List<String> MINIMAL_ROLES = Arrays.asList("Member");
    @JsonProperty(value="aud")
    private String context;
    @JsonProperty(value="resource_access")
    private Map<String, Roles> contextAccess = new HashMap<String, Roles>();
    @JsonProperty(value="preferred_username")
    private String username;
    @JsonProperty(value="given_name")
    private String firstName;
    @JsonProperty(value="family_name")
    private String lastName;
    @JsonProperty(value="email")
    private String email;

    public List<String> getRoles() {
        return this.contextAccess.get(this.context) == null ? MINIMAL_ROLES : this.contextAccess.get((Object)this.context).roles;
    }

    public String getContext() {
        try {
            return URLDecoder.decode(this.context, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return this.context;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "GcubeJwt [context=" + this.getContext() + ", roles=" + this.getRoles() + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + "]";
    }

    public static class Roles {
        @JsonProperty(value="roles")
        List<String> roles = new ArrayList<String>();
    }
}

