/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="context-retriever")
public class RequestContextRetriever
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestContextRetriever.class);
    private static final String BEARER_AUTH_PREFIX = "Bearer";
    private static final String BASIC_AUTH_PREFIX = "Basic";

    @Override
    public String getName() {
        return "context-retriever";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        String token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        String scope = call.request().getParameter("gcube-scope") == null ? call.request().getHeader("gcube-scope") : call.request().getParameter("gcube-scope");
        String authHeader = call.request().getHeader("Authorization");
        log.debug("auth header is {}", (Object)authHeader);
        String umaToken = null;
        if (authHeader != null && !authHeader.isEmpty()) {
            if (authHeader.startsWith(BEARER_AUTH_PREFIX)) {
                umaToken = authHeader.substring(BEARER_AUTH_PREFIX.length()).trim();
            } else if (token == null && authHeader.startsWith(BASIC_AUTH_PREFIX)) {
                String basicAuthToken = authHeader.substring(BASIC_AUTH_PREFIX.length()).trim();
                String decodedAuth = new String(Base64.getDecoder().decode(basicAuthToken.getBytes()));
                token = decodedAuth.split(":")[1];
            }
        }
        if (umaToken != null) {
            this.retreiveAndSetInfoUmaToken(umaToken, token, call);
        } else if (token != null) {
            this.retreiveAndSetInfoGcubeToken(token, call);
        } else if (scope != null) {
            ScopeProvider.instance.set(scope);
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        SecurityTokenProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        UmaJWTProvider.instance.reset();
        ScopeProvider.instance.reset();
        log.debug("resetting all the Thread local for this call.");
    }

    private void retreiveAndSetInfoGcubeToken(String token, RequestEvent call) {
        log.info("retrieving context using token {} ", (Object)token);
        AuthorizationEntry authEntry = null;
        try {
            authEntry = Constants.authorizationService().get(token);
        }
        catch (ObjectNotFound onf) {
            log.warn("rejecting call to {}, invalid token {}", (Object)((ApplicationContext)call.context()).name(), (Object)token);
            RequestError.invalid_request_error.fire(((ApplicationContext)call.context()).name() + " invalid token : " + token);
        }
        catch (Exception e) {
            log.error("error contacting authorization service", (Throwable)e);
            RequestError.internal_server_error.fire("error contacting authorization service");
        }
        AuthorizationProvider.instance.set(new Caller(authEntry.getClientInfo(), authEntry.getQualifier()));
        SecurityTokenProvider.instance.set(token);
        ScopeProvider.instance.set(authEntry.getContext());
        log.info("retrieved request authorization info {} in scope {} ", (Object)AuthorizationProvider.instance.get(), (Object)authEntry.getContext());
    }

    private void retreiveAndSetInfoUmaToken(String umaToken, String gcubeToken, RequestEvent call) {
        log.info("using UMA token for authorization");
        log.debug("retrieving context using uma token {} ", (Object)umaToken);
        UmaJWTProvider.instance.set(umaToken);
        SecurityTokenProvider.instance.set(gcubeToken);
        this.parseUmaTokenAndSet(umaToken);
        log.info("retrieved request authorization info {} in scope {} ", (Object)AuthorizationProvider.instance.get(), (Object)ScopeProvider.instance.get());
    }

    private void parseUmaTokenAndSet(String umaToken) {
        String realUmaTokenEncoded = umaToken.split("\\.")[1];
        String realUmaToken = new String(Base64.getDecoder().decode(realUmaTokenEncoded.getBytes()));
        JsonObject object = Json.parse((String)realUmaToken).asObject();
        String username = object.get("preferred_username").asString();
        String scope = object.getString("aud", null);
        log.debug("token related context is {}", (Object)scope);
        JsonObject resource = object.get("resource_access").asObject();
        log.debug("resource access is {}", (Object)resource.toString());
        JsonObject scopeObject = resource.get(scope).asObject();
        ScopeBean scopeBean = null;
        try {
            String decodedName = URLDecoder.decode(scope, StandardCharsets.UTF_8.toString());
            scopeBean = new ScopeBean(decodedName);
        }
        catch (Exception e2) {
            log.error("error decoding uma token", (Throwable)e2);
            RequestError.internal_server_error.fire("error contacting authorization service");
        }
        JsonArray roles = scopeObject.get("roles").asArray();
        ArrayList userRoles = new ArrayList();
        roles.forEach(e -> userRoles.add(e.asString()));
        AuthorizationProvider.instance.set(new Caller((ClientInfo)new UserInfo(username, userRoles), "token"));
        ScopeProvider.instance.set(scopeBean.toString());
    }
}

