/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.validations.validators;

import java.io.Serializable;
import java.util.List;
import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.datamodel.basetypes.AbstractServiceUsageRecord;
import org.gcube.accounting.datamodel.validations.validators.MatcherReplace;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.FieldAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Harmonizer
implements FieldAction {
    private static Logger logger = LoggerFactory.getLogger(Harmonizer.class);

    public Serializable validate(String key, Serializable value, Record record) throws InvalidValueException {
        if (!(record instanceof AbstractServiceUsageRecord)) {
            throw new RuntimeException(record.toString() + "is not an instace of " + AbstractServiceUsageRecord.class.getSimpleName());
        }
        if (!(value instanceof String)) {
            throw new InvalidValueException(value.toString() + "is not a " + String.class.getSimpleName());
        }
        AbstractServiceUsageRecord serviceUsageRecord = (AbstractServiceUsageRecord)record;
        String serviceClass = serviceUsageRecord.getServiceClass();
        if (serviceClass == null) {
            logger.debug("{} is not already set. The check will be postponed to validation phase", (Object)"serviceClass");
            return value;
        }
        String serviceName = serviceUsageRecord.getServiceName();
        if (serviceName == null) {
            logger.debug("{} is not already set. The check will be postponed to validation phase", (Object)"serviceName");
            return value;
        }
        List<MatcherReplace> matcherReplaceList = RegexRulesAggregator.getInstance().getMatcherReplaceList();
        for (MatcherReplace matcherReplace : matcherReplaceList) {
            boolean matched = matcherReplace.check(serviceClass, serviceName, (String)((Object)value));
            if (!matched) continue;
            serviceUsageRecord.setServiceClass(matcherReplace.getReplacer().getServiceClass());
            serviceUsageRecord.setServiceName(matcherReplace.getReplacer().getServiceName());
            return matcherReplace.getReplacer().getCalledMethod();
        }
        return value;
    }
}

