/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.DefaultPersitenceExecutor;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackMonitor;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackend.class);
    public static final long MAX_TIME_TO_FALLBACK = 1800000L;
    public static final int MAX_FALLBACK_RETRY = 3;
    protected boolean forceFallbackUse;
    protected int fallbackUseCounter;
    protected long fallbackUseStartTime;
    protected FallbackPersistenceBackend fallbackPersistence;
    protected AggregationScheduler aggregationScheduler;
    protected FallbackMonitor persistenceBackendMonitor;

    protected PersistenceBackend() {
        if (!(this instanceof FallbackPersistenceBackend)) {
            this.persistenceBackendMonitor = new FallbackMonitor(this);
        }
        this.forceFallbackUse = false;
        this.fallbackUseCounter = 0;
        this.fallbackUseStartTime = 0L;
    }

    protected PersistenceBackend(FallbackPersistenceBackend fallback) {
        this();
        this.fallbackPersistence = fallback;
        this.aggregationScheduler = AggregationScheduler.newInstance(new DefaultPersitenceExecutor(this));
    }

    public FallbackPersistenceBackend getFallbackPersistence() {
        return this.fallbackPersistence;
    }

    protected void setFallback(FallbackPersistenceBackend fallback) {
        this.fallbackPersistence = fallback;
    }

    public AggregationScheduler getAggregationScheduler() {
        return this.aggregationScheduler;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(PersistenceBackendConfiguration var1) throws Exception;

    protected abstract void openConnection() throws Exception;

    protected abstract void closeConnection() throws Exception;

    public void close() throws Exception {
        this.flush();
        this.closeConnection();
    }

    protected abstract void clean() throws Exception;

    public abstract boolean isConnectionActive() throws Exception;

    protected abstract void reallyAccount(Record var1) throws Exception;

    protected void accountWithFallback(Record ... records) throws Exception {
        String persistenceName = this.getClass().getSimpleName();
        String fallbackPersistenceName = FallbackPersistenceBackend.class.getSimpleName();
        this.openConnection();
        for (Record record : records) {
            String recordString = null;
            try {
                recordString = record.toString();
                if (this.forceFallbackUse) {
                    logger.trace("Forcing the use of {} to account {}", (Object)fallbackPersistenceName, (Object)recordString);
                    this.fallbackPersistence.reallyAccount(record);
                    long now = Calendar.getInstance().getTimeInMillis();
                    long diff = now - this.fallbackUseStartTime;
                    logger.trace("{} forced use started at {}. {} seconds were elapsed", new Object[]{fallbackPersistenceName, this.fallbackUseStartTime, diff / 1000L});
                    if (diff <= 1800000L) continue;
                    logger.debug("The time to force the usage of {} is terminated. Trying to restore the use of {}", (Object)fallbackPersistenceName, (Object)persistenceName);
                    this.forceFallbackUse = false;
                    this.fallbackUseCounter = 0;
                    this.fallbackUseStartTime = 0L;
                    continue;
                }
                this.reallyAccount(record);
                logger.trace("{} accounted succesfully from {}.", (Object)record.toString(), (Object)persistenceName);
            }
            catch (Throwable t) {
                try {
                    logger.warn("{} was not accounted succesfully using {}. Trying to use {}.", new Object[]{recordString, persistenceName, fallbackPersistenceName, t});
                    this.fallbackPersistence.reallyAccount(record);
                    logger.trace("{} accounted succesfully from {}", (Object)recordString, (Object)fallbackPersistenceName);
                }
                catch (Throwable th) {
                    logger.error("{} was not accounted at all", (Object)recordString, (Object)t);
                }
                if (this instanceof FallbackPersistenceBackend) continue;
                ++this.fallbackUseCounter;
                logger.warn("Exception number is {}. Max Retry number is {}. After that the use of {} will be forced", new Object[]{this.fallbackUseCounter, 3, fallbackPersistenceName});
                if (this.fallbackUseCounter != 3) continue;
                this.forceFallbackUse = true;
                this.fallbackUseStartTime = Calendar.getInstance().getTimeInMillis();
                logger.trace("Going to force {} for too many Exceptions", (Object)fallbackPersistenceName);
                this.aggregationScheduler.flush(new DefaultPersitenceExecutor(this.fallbackPersistence));
                this.close();
                this.clean();
            }
        }
        this.closeConnection();
    }

    protected void accountValidateAggregate(Record record, boolean validate, boolean aggregate) {
        try {
            logger.trace("Received {} to account : {}", (Object)record.getClass().getSimpleName(), (Object)record);
            if (validate) {
                record.validate();
            }
            if (aggregate) {
                try {
                    this.aggregationScheduler.aggregate(record, new DefaultPersitenceExecutor(this));
                }
                catch (Exception e) {
                    this.accountWithFallback(record);
                }
            } else {
                this.accountWithFallback(record);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Error recording {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
    }

    public void account(final Record record) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PersistenceBackend.this.accountValidateAggregate(record, true, true);
            }
        };
        ExecutorUtils.threadPool.execute(runnable);
    }

    @Deprecated
    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        this.flush();
    }

    public void flush() throws Exception {
        this.aggregationScheduler.flush(new DefaultPersitenceExecutor(this));
    }
}

