/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.FixDataVolumeSign;
import org.gcube.accounting.datamodel.validations.annotations.ValidDataType;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationType;
import org.gcube.accounting.datamodel.validations.annotations.ValidURI;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmptyIfNotNull;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public abstract class AbstractStorageUsageRecord
extends BasicUsageRecord {
    private static final long serialVersionUID = 1381025822586583326L;
    @RequiredField
    @NotEmpty
    public static final String RESOURCE_OWNER = "resourceOwner";
    @RequiredField
    @NotEmpty
    public static final String RESOURCE_SCOPE = "resourceScope";
    @RequiredField
    @ValidURI
    public static final String RESOURCE_URI = "resourceURI";
    @RequiredField
    @ValidURI
    public static final String PROVIDER_URI = "providerURI";
    @RequiredField
    @ValidOperationType
    @FixDataVolumeSign
    public static final String OPERATION_TYPE = "operationType";
    @RequiredField
    @ValidDataType
    public static final String DATA_TYPE = "dataType";
    @RequiredField
    @ValidLong
    @FixDataVolumeSign
    public static final String DATA_VOLUME = "dataVolume";
    @NotEmptyIfNotNull
    public static final String QUALIFIER = "qualifier";
    private static final String ABSTRACT_TO_REPLACE = "Abstract";

    public AbstractStorageUsageRecord() {
    }

    public AbstractStorageUsageRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    @Override
    public String getRecordType() {
        return AbstractStorageUsageRecord.class.getSimpleName().replace(ABSTRACT_TO_REPLACE, "");
    }

    @JsonIgnore
    public String getResourceOwner() {
        return (String)this.resourceProperties.get(RESOURCE_OWNER);
    }

    @JsonIgnore
    public void setResourceOwner(String owner) throws InvalidValueException {
        this.setResourceProperty(RESOURCE_OWNER, (Serializable)((Object)owner));
    }

    @JsonIgnore
    public String getResourceScope() {
        return (String)this.resourceProperties.get(RESOURCE_SCOPE);
    }

    @JsonIgnore
    public void setResourceScope(String scope) throws InvalidValueException {
        this.setResourceProperty(RESOURCE_SCOPE, (Serializable)((Object)scope));
    }

    @JsonIgnore
    public URI getProviderURI() {
        return (URI)this.resourceProperties.get(PROVIDER_URI);
    }

    @JsonIgnore
    public void setProviderURI(URI providerURI) throws InvalidValueException {
        this.setResourceProperty(PROVIDER_URI, providerURI);
    }

    @JsonIgnore
    public URI getResourceURI() {
        return (URI)this.resourceProperties.get(RESOURCE_URI);
    }

    @JsonIgnore
    public void setResourceURI(URI resourceURI) throws InvalidValueException {
        this.setResourceProperty(RESOURCE_URI, resourceURI);
    }

    @JsonIgnore
    public OperationType getOperationType() {
        return (OperationType)((Object)this.resourceProperties.get(OPERATION_TYPE));
    }

    @JsonIgnore
    public void setOperationType(OperationType operationType) throws InvalidValueException {
        this.setResourceProperty(OPERATION_TYPE, (Serializable)((Object)operationType));
    }

    @JsonIgnore
    public DataType getDataType() {
        return (DataType)((Object)this.resourceProperties.get(DATA_TYPE));
    }

    @JsonIgnore
    public void setDataType(DataType dataType) throws InvalidValueException {
        this.setResourceProperty(DATA_TYPE, (Serializable)((Object)dataType));
    }

    @JsonIgnore
    public long getDataVolume() {
        return (Long)this.resourceProperties.get(DATA_VOLUME);
    }

    @JsonIgnore
    public void setDataVolume(long dataVolume) throws InvalidValueException {
        this.setResourceProperty(DATA_VOLUME, Long.valueOf(dataVolume));
    }

    @JsonIgnore
    public String getQualifier() {
        return (String)this.resourceProperties.get(QUALIFIER);
    }

    @JsonIgnore
    public void setQualifier(String qualifier) throws InvalidValueException {
        this.setResourceProperty(QUALIFIER, (Serializable)((Object)qualifier));
    }

    public static enum DataType {
        STORAGE,
        TREE,
        GEO,
        DATABASE,
        OTHER;

    }

    public static enum OperationType {
        CREATE,
        READ,
        UPDATE,
        DELETE;

    }
}

