/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.BucketServiceMapping;
import com.couchbase.client.core.service.EndpointStateZipper;
import com.couchbase.client.core.service.Service;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public abstract class AbstractDynamicService
extends AbstractStateMachine<LifecycleState>
implements Service {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Service.class);
    private final Endpoint[] endpoints;
    private final String hostname;
    private final String bucket;
    private final String username;
    private final String password;
    private final int port;
    private final CoreEnvironment env;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final int minEndpoints;
    private final Service.EndpointFactory endpointFactory;
    private final EndpointStateZipper endpointStates;
    private final LifecycleState initialState;

    protected AbstractDynamicService(String hostname, String bucket, String username, String password, int port, CoreEnvironment env, int minEndpoints, RingBuffer<ResponseEvent> responseBuffer, Service.EndpointFactory endpointFactory) {
        super(minEndpoints == 0 ? LifecycleState.IDLE : LifecycleState.DISCONNECTED);
        this.initialState = minEndpoints == 0 ? LifecycleState.IDLE : LifecycleState.DISCONNECTED;
        this.hostname = hostname;
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.port = port;
        this.env = env;
        this.minEndpoints = minEndpoints;
        this.responseBuffer = responseBuffer;
        this.endpointFactory = endpointFactory;
        this.endpointStates = new EndpointStateZipper(this.initialState);
        this.endpoints = new Endpoint[minEndpoints];
        this.endpointStates.states().subscribe((Action1)new Action1<LifecycleState>(){

            public void call(LifecycleState lifecycleState) {
                AbstractDynamicService.this.transitionState(lifecycleState);
            }
        });
    }

    protected abstract void dispatch(CouchbaseRequest var1);

    @Override
    public Observable<LifecycleState> connect() {
        LOGGER.debug(AbstractDynamicService.logIdent(this.hostname, this) + "Got instructed to connect.");
        if (this.state() == LifecycleState.CONNECTED || this.state() == LifecycleState.CONNECTING) {
            LOGGER.debug(AbstractDynamicService.logIdent(this.hostname, this) + "Already connected or connecting, skipping connect.");
            return Observable.just(this.state());
        }
        for (int i = 0; i < this.minEndpoints; ++i) {
            Endpoint endpoint;
            this.endpoints[i] = endpoint = this.createEndpoint();
            this.endpointStates.register(endpoint, endpoint);
        }
        return Observable.from((Object[])this.endpoints).flatMap((Func1)new Func1<Endpoint, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Endpoint endpoint) {
                LOGGER.debug(AbstractDynamicService.logIdent(AbstractDynamicService.this.hostname, AbstractDynamicService.this) + "Initializing connect on Endpoint.");
                return endpoint.connect();
            }
        }).lastOrDefault((Object)this.initialState).map((Func1)new Func1<LifecycleState, LifecycleState>(){

            public LifecycleState call(LifecycleState state) {
                return (LifecycleState)((Object)AbstractDynamicService.this.state());
            }
        });
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (request instanceof SignalFlush) {
            for (Endpoint endpoint : this.endpoints) {
                if (endpoint == null) continue;
                endpoint.send(request);
            }
            return;
        }
        this.dispatch(request);
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        LOGGER.debug(AbstractDynamicService.logIdent(this.hostname, this) + "Got instructed to disconnect.");
        if (this.state() == LifecycleState.DISCONNECTED || this.state() == LifecycleState.DISCONNECTING) {
            LOGGER.debug(AbstractDynamicService.logIdent(this.hostname, this) + "Already disconnected or disconnecting, skipping disconnect.");
            return Observable.just(this.state());
        }
        return Observable.from((Object[])this.endpoints).flatMap((Func1)new Func1<Endpoint, Observable<LifecycleState>>(){

            public Observable<LifecycleState> call(Endpoint endpoint) {
                LOGGER.debug(AbstractDynamicService.logIdent(AbstractDynamicService.this.hostname, AbstractDynamicService.this) + "Initializing disconnect on Endpoint.");
                return endpoint.disconnect();
            }
        }).lastOrDefault((Object)this.initialState).map((Func1)new Func1<LifecycleState, LifecycleState>(){

            public LifecycleState call(LifecycleState state) {
                AbstractDynamicService.this.endpointStates.terminate();
                return (LifecycleState)((Object)AbstractDynamicService.this.state());
            }
        });
    }

    @Override
    public BucketServiceMapping mapping() {
        return this.type().mapping();
    }

    protected Endpoint createEndpoint() {
        return this.endpointFactory.create(this.hostname, this.bucket, this.username, this.password, this.port, this.env, this.responseBuffer);
    }

    protected static String logIdent(String hostname, Service service) {
        return "[" + hostname + "][" + service.getClass().getSimpleName() + "]: ";
    }

    protected List<Endpoint> endpoints() {
        return Arrays.asList(this.endpoints);
    }

    protected EndpointStateZipper endpointStates() {
        return this.endpointStates;
    }

    protected static void whenState(Endpoint endpoint, final LifecycleState wanted, Action1<LifecycleState> then) {
        endpoint.states().filter((Func1)new Func1<LifecycleState, Boolean>(){

            public Boolean call(LifecycleState state) {
                return state == wanted;
            }
        }).take(1).subscribe(then);
    }
}

