/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.utils.sweeper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.utils.sweeper.ContextBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweeper {
    String ghn_state_path = "";
    Logger logger;
    String ghn_path;
    String id;
    List<ContextBean> contextBeans = new ArrayList<ContextBean>();

    public Sweeper() throws Exception {
        this.logger = LoggerFactory.getLogger(Sweeper.class);
        this.ghn_path = System.getenv("GHN_HOME");
        if (this.ghn_path == null) {
            this.logger.error("GHN_HOME not defined");
            throw new Exception("GHN_HOME not defined");
        }
        this.ghn_state_path = this.ghn_path + File.separator + "state";
        this.deserializeState();
    }

    private void deserializeState() {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.ghn_state_path + File.separator + "ghn.xml"));){
            this.id = (String)ois.readObject();
            List tokens = (List)ois.readObject();
            for (String token : tokens) {
                System.out.println("checking authorization for token " + token);
                AuthorizationEntry entry = Constants.authorizationService().get(token);
                this.contextBeans.add(new ContextBean(token, entry.getContext()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error loading persisted state", e);
        }
    }

    public void forceDeleteHostingNode() {
        RegistryPublisher rp = RegistryPublisherFactory.create();
        try {
            DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
            XQuery query = ICFactory.queryFor(HostingNode.class);
            query.addCondition("$resource/ID/text() = '" + this.id + "'");
            for (ContextBean contextBean : this.contextBeans) {
                SecurityTokenProvider.instance.set(contextBean.getToken());
                ScopeProvider.instance.set(contextBean.getContext());
                List nodes = client.submit((Query)query);
                if (nodes.isEmpty()) continue;
                rp.remove((Resource)nodes.get(0));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error removing hosting node resource", e);
        }
    }

    public void saveTokens(String fileName) {
        File file = new File(this.ghn_path + File.separator + fileName);
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        try (FileWriter fw = new FileWriter(file);){
            for (ContextBean bean : this.contextBeans) {
                fw.write("<token>" + bean.getToken() + "</token> <!--- " + bean.getContext() + " -->\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

