/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPersistenceBackend
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(FallbackPersistenceBackend.class);
    private File fallbackFile;

    protected File getFallbackFile() {
        return this.fallbackFile;
    }

    protected FallbackPersistenceBackend(File fallbackFile) {
        super(null);
        this.fallbackFile = fallbackFile;
    }

    @Override
    public void prepareConnection(PersistenceBackendConfiguration configuration) {
    }

    @Override
    protected void openConnection() throws Exception {
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    protected void reallyAccount(Record record) throws Exception {
        String marshalled = DSMapper.marshal(record);
        logger.debug("reallyAccount:{}", (Object)marshalled);
        this.printLine(marshalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLine(String line) throws Exception {
        File file = this.fallbackFile;
        synchronized (file) {
            try (FileWriter fw = new FileWriter(this.fallbackFile, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
                out.flush();
            }
        }
    }

    @Override
    protected void closeConnection() throws Exception {
    }
}

