/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.query.parser;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.query.GenericQueryResponse;
import com.couchbase.client.core.utils.UnicastAutoReleaseSubject;
import com.couchbase.client.core.utils.yasjl.ByteBufJsonParser;
import com.couchbase.client.core.utils.yasjl.Callbacks.JsonPointerCB1;
import com.couchbase.client.core.utils.yasjl.JsonPointer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.AsyncSubject;

public class YasjlQueryResponseParser {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(YasjlQueryResponseParser.class);
    private ByteBufJsonParser parser;
    private String requestID;
    private String clientContextID;
    private boolean sentResponse;
    protected static final Charset CHARSET = CharsetUtil.UTF_8;
    protected ByteBuf responseContent;
    protected UnicastAutoReleaseSubject<ByteBuf> queryRowObservable;
    protected UnicastAutoReleaseSubject<ByteBuf> querySignatureObservable;
    protected UnicastAutoReleaseSubject<ByteBuf> queryErrorObservable;
    protected AsyncSubject<String> queryStatusObservable;
    protected UnicastAutoReleaseSubject<ByteBuf> queryInfoObservable;
    protected CouchbaseRequest currentRequest;
    protected Scheduler scheduler;
    protected long ttl;
    protected ResponseStatus status;
    protected boolean initialized;
    protected GenericQueryResponse response;

    public YasjlQueryResponseParser(Scheduler scheduler, long ttl) {
        this.scheduler = scheduler;
        this.ttl = ttl;
        this.response = null;
        JsonPointer[] jsonPointers = new JsonPointer[]{new JsonPointer("/requestID", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                YasjlQueryResponseParser.this.requestID = buf.toString(CHARSET);
                YasjlQueryResponseParser.this.requestID = YasjlQueryResponseParser.this.requestID.substring(1, YasjlQueryResponseParser.this.requestID.length() - 1);
                buf.release();
                if (YasjlQueryResponseParser.this.queryRowObservable != null) {
                    YasjlQueryResponseParser.this.queryRowObservable.withTraceIdentifier("queryRow." + YasjlQueryResponseParser.this.requestID);
                }
                if (YasjlQueryResponseParser.this.queryErrorObservable != null) {
                    YasjlQueryResponseParser.this.queryErrorObservable.withTraceIdentifier("queryError." + YasjlQueryResponseParser.this.requestID);
                }
                if (YasjlQueryResponseParser.this.queryInfoObservable != null) {
                    YasjlQueryResponseParser.this.queryInfoObservable.withTraceIdentifier("queryInfo." + YasjlQueryResponseParser.this.requestID);
                }
                if (YasjlQueryResponseParser.this.querySignatureObservable != null) {
                    YasjlQueryResponseParser.this.querySignatureObservable.withTraceIdentifier("querySignature." + YasjlQueryResponseParser.this.requestID);
                }
            }
        }), new JsonPointer("/clientContextID", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                YasjlQueryResponseParser.this.clientContextID = buf.toString(CHARSET);
                YasjlQueryResponseParser.this.clientContextID = YasjlQueryResponseParser.this.clientContextID.substring(1, YasjlQueryResponseParser.this.clientContextID.length() - 1);
                buf.release();
            }
        }), new JsonPointer("/signature", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.querySignatureObservable != null) {
                    YasjlQueryResponseParser.this.querySignatureObservable.onNext(buf);
                }
            }
        }), new JsonPointer("/status", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.queryStatusObservable != null) {
                    String statusStr = buf.toString(CHARSET);
                    buf.release();
                    statusStr = statusStr.substring(1, statusStr.length() - 1);
                    if (!statusStr.equals("success")) {
                        YasjlQueryResponseParser.this.status = ResponseStatus.FAILURE;
                    }
                    YasjlQueryResponseParser.this.queryStatusObservable.onNext((Object)statusStr);
                    if (!YasjlQueryResponseParser.this.sentResponse) {
                        YasjlQueryResponseParser.this.createResponse();
                        LOGGER.trace("Received status for requestId {}", (Object)YasjlQueryResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/metrics", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.queryInfoObservable != null) {
                    YasjlQueryResponseParser.this.queryInfoObservable.onNext(buf);
                }
            }
        }), new JsonPointer("/results/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.queryRowObservable != null) {
                    YasjlQueryResponseParser.this.queryRowObservable.onNext(buf);
                    if (YasjlQueryResponseParser.this.response == null) {
                        YasjlQueryResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving results for requestId {}", (Object)YasjlQueryResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/errors/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.queryErrorObservable != null) {
                    YasjlQueryResponseParser.this.queryErrorObservable.onNext(buf);
                    if (YasjlQueryResponseParser.this.response == null) {
                        YasjlQueryResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving errors for requestId {}", (Object)YasjlQueryResponseParser.this.requestID);
                    }
                }
            }
        }), new JsonPointer("/warnings/-", new JsonPointerCB1(){

            @Override
            public void call(ByteBuf buf) {
                if (YasjlQueryResponseParser.this.queryErrorObservable != null) {
                    YasjlQueryResponseParser.this.queryErrorObservable.onNext(buf);
                    if (YasjlQueryResponseParser.this.response == null) {
                        YasjlQueryResponseParser.this.createResponse();
                        LOGGER.trace("Started receiving warnings for requestId {}", (Object)YasjlQueryResponseParser.this.requestID);
                    }
                }
            }
        })};
        this.parser = new ByteBufJsonParser(jsonPointers);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(ByteBuf responseContent, ResponseStatus responseStatus) {
        this.requestID = "";
        this.clientContextID = "";
        this.sentResponse = false;
        this.response = null;
        this.status = responseStatus;
        this.responseContent = responseContent;
        this.queryRowObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.queryErrorObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.queryStatusObservable = AsyncSubject.create();
        this.queryInfoObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.querySignatureObservable = UnicastAutoReleaseSubject.create(this.ttl, TimeUnit.MILLISECONDS, this.scheduler);
        this.parser.initialize(responseContent);
        this.initialized = true;
    }

    private void createResponse() {
        this.response = new GenericQueryResponse((Observable<ByteBuf>)this.queryErrorObservable.onBackpressureBuffer().observeOn(this.scheduler), (Observable<ByteBuf>)this.queryRowObservable.onBackpressureBuffer().observeOn(this.scheduler), (Observable<ByteBuf>)this.querySignatureObservable.onBackpressureBuffer().observeOn(this.scheduler), (Observable<String>)this.queryStatusObservable.onBackpressureBuffer().observeOn(this.scheduler), (Observable<ByteBuf>)this.queryInfoObservable.onBackpressureBuffer().observeOn(this.scheduler), this.currentRequest, this.status, this.requestID, this.clientContextID);
    }

    public GenericQueryResponse parse(boolean lastChunk) throws Exception {
        try {
            this.parser.parse();
            this.responseContent.discardSomeReadBytes();
            LOGGER.trace("Received last chunk and completed parsing for requestId {}", (Object)this.requestID);
        }
        catch (EOFException ex) {
            LOGGER.trace("Still expecting more data for requestId {}", (Object)this.requestID);
        }
        if (!this.sentResponse && this.response != null) {
            this.sentResponse = true;
            return this.response;
        }
        return null;
    }

    public void finishParsingAndReset() {
        if (this.queryRowObservable != null) {
            this.queryRowObservable.onCompleted();
        }
        if (this.queryInfoObservable != null) {
            this.queryInfoObservable.onCompleted();
        }
        if (this.queryErrorObservable != null) {
            this.queryErrorObservable.onCompleted();
        }
        if (this.queryStatusObservable != null) {
            this.queryStatusObservable.onCompleted();
        }
        if (this.querySignatureObservable != null) {
            this.querySignatureObservable.onCompleted();
        }
        this.queryInfoObservable = null;
        this.queryRowObservable = null;
        this.queryErrorObservable = null;
        this.queryStatusObservable = null;
        this.querySignatureObservable = null;
        this.initialized = false;
    }
}

