/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.PolicyUtils;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.ServiceIdentifier;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-validation")
public class RequestValidator
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext context;

    @Override
    public void handleRequest(RequestEvent call) {
        log.trace("executing request validator ON REQUEST");
        this.context = (ApplicationContext)call.context();
        this.validateAgainstLifecycle(call);
        if (!this.validateToken(call)) {
            String scope = call.request().getParameter("gcube-scope") == null ? call.request().getHeader("gcube-scope") : call.request().getParameter("gcube-scope");
            this.validateScope(scope);
            log.info("received call to {} in context {}", (Object)call.uri(), (Object)scope);
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        SecurityTokenProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        ScopeProvider.instance.reset();
        log.debug("resetting all the Thread local for this call.");
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.context.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScope(String scope) {
        if (scope == null) {
            log.warn("rejecting unscoped call to {}", (Object)this.context.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        if (!this.context.container().configuration().allowedContexts().contains(scope)) {
            log.warn("rejecting call to {} in invalid context {}", (Object)this.context.name(), (Object)scope);
            RequestError.invalid_request_error.fire(this.context.name() + " cannot be called in scope " + scope);
        }
        ScopeProvider.instance.set(scope);
    }

    private boolean validateToken(RequestEvent call) {
        String scope;
        String token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        String string = scope = call.request().getParameter("gcube-scope") == null ? call.request().getHeader("gcube-scope") : call.request().getParameter("gcube-scope");
        if (token == null && scope == null) {
            log.warn("rejecting call to {}, authorization required", (Object)this.context.name(), (Object)token);
            if (((ApplicationContext)call.context()).container().configuration().authenticationEnpoint() == null) {
                if (call.request().getHeader("Authorization") != null) {
                    String basicAuthorization = call.request().getHeader("Authorization");
                    String base64Credentials = basicAuthorization.substring("Basic".length()).trim();
                    String credentials = new String(DatatypeConverter.parseBase64Binary((String)base64Credentials));
                    String[] values = credentials.split(":", 2);
                    token = values[1];
                    ClientInfo info = this.retreiveAndSetInfo(token, call);
                    if (!(info instanceof UserInfo) || !info.getId().equals(values[0])) {
                        log.warn("rejecting call to {}, username {} not valid for token {}", new Object[]{this.context.name(), values[0], token});
                        RequestError.request_not_authorized_error.fire(this.context.name() + ": username " + values[0] + " not valid for token " + token);
                    }
                    return true;
                }
                log.warn("rejecting call to {}, authorization required", (Object)this.context.name(), (Object)token);
                RequestError.request_not_authorized_error.fire(this.context.name() + ": authorization required");
            } else {
                log.info("authorization enpoint found on configuration, redirecting the call");
                String recallLocation = String.format("http://%s:%d%s", ((ApplicationContext)call.context()).container().configuration().hostname(), ((ApplicationContext)call.context()).container().configuration().port(), call.uri());
                try {
                    call.response().sendRedirect(this.context.container().configuration().authenticationEnpoint() + "?Recall-Location=" + recallLocation);
                }
                catch (IOException e) {
                    log.error("errror redirecting call", (Throwable)e);
                }
                return false;
            }
        }
        log.trace("token is " + token);
        if (token != null) {
            this.retreiveAndSetInfo(token, call);
            return true;
        }
        log.info("invalid token, checking the context");
        return false;
    }

    @Override
    public String toString() {
        return "request-validation";
    }

    private ClientInfo retreiveAndSetInfo(String token, RequestEvent call) {
        log.info("accessing  validator with token {} ", (Object)token);
        AuthorizationEntry authEntry = null;
        try {
            authEntry = Constants.authorizationService().get(token);
        }
        catch (ObjectNotFound onf) {
            log.warn("rejecting call to {}, invalid token {}", (Object)this.context.name(), (Object)token);
            RequestError.invalid_request_error.fire(this.context.name() + " invalid token : " + token);
        }
        catch (Exception e) {
            log.error("error contacting authorization service", (Throwable)e);
            RequestError.internal_server_error.fire("error contacting authorization service");
        }
        ServiceIdentifier serviceIdentifier = Utils.getServiceInfo((ApplicationContext)call.context()).getServiceIdentifier();
        for (Policy policy : authEntry.getPolicies()) {
            if (!PolicyUtils.isPolicyValidForClient((ServiceAccess)policy.getServiceAccess(), (ServiceIdentifier)serviceIdentifier)) continue;
            log.error("rejecting call to {} : {} is not allowed to contact the service ", (Object)this.context.name(), (Object)authEntry.getClientInfo().getId());
            RequestError.invalid_request_error.fire("rejecting call to " + this.context.name() + ": " + authEntry.getClientInfo().getId() + " is not allowed to contact the service");
        }
        AuthorizationProvider.instance.set(new Caller(authEntry.getClientInfo(), authEntry.getQualifier()));
        this.validateScope(authEntry.getContext());
        log.info("retrieved request authorization info {} in scope {} ", (Object)AuthorizationProvider.instance.get(), (Object)authEntry.getContext());
        SecurityTokenProvider.instance.set(token);
        return authEntry.getClientInfo();
    }
}

