/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Notification;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;
import rx.plugins.RxJavaPlugins;

public final class OperatorMaterialize<T>
implements Observable.Operator<Notification<T>, T> {
    public static <T> OperatorMaterialize<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorMaterialize() {
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Notification<T>> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n > 0L) {
                    parent.requestMore(n);
                }
            }
        });
        return parent;
    }

    private static class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super Notification<T>> child;
        private volatile Notification<T> terminalNotification;
        private boolean busy = false;
        private boolean missed = false;
        private volatile long requested;
        private static final AtomicLongFieldUpdater<ParentSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ParentSubscriber.class, "requested");

        ParentSubscriber(Subscriber<? super Notification<T>> child) {
            this.child = child;
        }

        @Override
        public void onStart() {
            this.request(0L);
        }

        void requestMore(long n) {
            BackpressureUtils.getAndAddRequest(REQUESTED, this, n);
            this.request(n);
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.terminalNotification = Notification.createOnCompleted();
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.terminalNotification = Notification.createOnError(e);
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            this.drain();
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(Notification.createOnNext(t));
            this.decrementRequested();
        }

        private void decrementRequested() {
            long r;
            do {
                if ((r = this.requested) != Long.MAX_VALUE) continue;
                return;
            } while (!REQUESTED.compareAndSet(this, r, r - 1L));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            ParentSubscriber parentSubscriber = this;
            synchronized (parentSubscriber) {
                if (this.busy) {
                    this.missed = true;
                    return;
                }
            }
            while (!this.child.isUnsubscribed()) {
                Notification<T> tn = this.terminalNotification;
                if (tn != null && this.requested > 0L) {
                    this.terminalNotification = null;
                    this.child.onNext(tn);
                    if (!this.child.isUnsubscribed()) {
                        this.child.onCompleted();
                    }
                    return;
                }
                ParentSubscriber parentSubscriber2 = this;
                synchronized (parentSubscriber2) {
                    if (!this.missed) {
                        this.busy = false;
                        return;
                    }
                }
            }
        }
    }

    private static final class Holder {
        static final OperatorMaterialize<Object> INSTANCE = new OperatorMaterialize();

        private Holder() {
        }
    }
}

