/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistenceBackendRediscover
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendRediscover.class);
    protected final ScheduledExecutorService scheduler;
    protected final String context;
    protected final FallbackPersistenceBackend fallbackPersistenceBackend;

    public PersistenceBackendRediscover(String context, FallbackPersistenceBackend fallbackPersistenceBackend, long initialDelay, long delay, TimeUnit timeUnit) {
        this.context = context;
        this.fallbackPersistenceBackend = fallbackPersistenceBackend;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this, initialDelay, delay, timeUnit);
    }

    @Override
    public void run() {
        logger.debug("Going to rediscover {}", (Object)PersistenceBackend.class.getSimpleName());
        PersistenceBackend rediscovered = PersistenceBackendFactory.rediscoverPersistenceBackend(this.fallbackPersistenceBackend, this.context);
        if (rediscovered != this.fallbackPersistenceBackend) {
            logger.debug("Another {} was found : {}. Shutting down {} Thread for context {}", new Object[]{PersistenceBackend.class.getSimpleName(), rediscovered.getClass().getSimpleName(), PersistenceBackendRediscover.class.getSimpleName(), this.context});
            this.scheduler.shutdown();
        } else {
            logger.debug("{} for contaxt {} is still a {}. We will see if next time we will be more lucky.", new Object[]{PersistenceBackend.class.getSimpleName(), this.context, FallbackPersistenceBackend.class.getSimpleName()});
        }
    }
}

