/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.builders;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.gcube.common.clients.builders.AbstractBuilder;
import org.gcube.common.clients.builders.AddressingUtils;
import org.gcube.common.clients.builders.StatelessBuilderAPI;
import org.gcube.common.clients.cache.EndpointCache;
import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.gcube.common.clients.queries.Query;

public abstract class AbstractStatelessBuilder<A, S, P>
extends AbstractBuilder<A, S, P>
implements StatelessBuilderAPI.Builder<P>,
StatelessBuilderAPI.SecondClause<P>,
StatelessBuilderAPI.FinalClause<P> {
    protected AbstractStatelessBuilder(ProxyPlugin<A, S, P> plugin, EndpointCache<A> cache, Query<A> query, Property<?> ... properties) {
        super(plugin, cache, properties);
        this.setQuery(query);
    }

    @Override
    public StatelessBuilderAPI.SecondClause<P> at(String host, int port) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), host, port));
        return this;
    }

    @Override
    public StatelessBuilderAPI.SecondClause<P> at(URL address) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), address));
        return this;
    }

    @Override
    public StatelessBuilderAPI.SecondClause<P> at(URI address) {
        this.setAddress(AddressingUtils.address(this.contextPath(), this.plugin().name(), address));
        return this;
    }

    @Override
    public StatelessBuilderAPI.FinalClause<P> withTimeout(int duration, TimeUnit unit) {
        this.setTimeout((int)unit.toMillis(duration));
        return this;
    }

    @Override
    public StatelessBuilderAPI.Builder<P> with(Property<?> property) {
        this.addProperty(property);
        return this;
    }

    @Override
    public <T> StatelessBuilderAPI.Builder<P> with(String name, T value) {
        this.addProperty(new Property<T>(name, value));
        return this;
    }
}

