/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.persistence.FallbackPersistence;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistenceBackendFactory {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceBackendFactory.class);
    public static final String HOME_SYSTEM_PROPERTY = "user.home";
    private static final String ACCOUTING_FALLBACK_FILENAME = "accountingFallback.log";
    private static String fallbackLocation;
    private static Map<String, AccountingPersistenceBackend> persistencePersistenceBackends;

    private static File file(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected static synchronized void setFallbackLocation(String path) {
        if (fallbackLocation == null) {
            if (path == null) {
                path = System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            AccountingPersistenceBackendFactory.file(new File(path));
            fallbackLocation = path;
        }
    }

    protected static synchronized AccountingPersistenceBackend getPersistenceBackend() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            logger.error("No Scope available. FallbackPersistence will be used");
            File fallbackFile = new File(fallbackLocation, ACCOUTING_FALLBACK_FILENAME);
            return new FallbackPersistence(fallbackFile);
        }
        AccountingPersistenceBackend persistence = persistencePersistenceBackends.get(scope);
        if (persistence == null) {
            ScopeBean bean = new ScopeBean(scope);
            String name = bean.name();
            File fallbackFile = new File(fallbackLocation, String.format("%s.%s", name, ACCOUTING_FALLBACK_FILENAME));
            FallbackPersistence fallbackPersistence = new FallbackPersistence(fallbackFile);
            try {
                ServiceLoader<AccountingPersistenceBackend> serviceLoader = ServiceLoader.load(AccountingPersistenceBackend.class);
                for (AccountingPersistenceBackend foundPersistence : serviceLoader) {
                    if (foundPersistence.getClass().isInstance(FallbackPersistence.class)) continue;
                    try {
                        String foundPersistenceClassName = foundPersistence.getClass().getSimpleName();
                        logger.debug("Testing {}", (Object)foundPersistenceClassName);
                        AccountingPersistenceConfiguration configuration = new AccountingPersistenceConfiguration(foundPersistenceClassName);
                        foundPersistence.prepareConnection(configuration);
                        persistence = foundPersistence;
                        logger.debug("{} will be used.", (Object)foundPersistenceClassName);
                        break;
                    }
                    catch (Exception e) {
                        logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundPersistence.getClass().getSimpleName()), (Throwable)e);
                    }
                }
                if (persistence == null) {
                    persistence = fallbackPersistence;
                }
            }
            catch (Exception e) {
                logger.error("Unable to instance a Persistence Implementation. Using fallback as default", (Throwable)e);
                persistence = fallbackPersistence;
            }
            persistence.setAggregationScheduler(AggregationScheduler.newInstance());
            persistence.setFallback(fallbackPersistence);
            persistencePersistenceBackends.put(scope, persistence);
        }
        return persistence;
    }

    public static void flush(long timeout, TimeUnit timeUnit) {
        for (String scope : persistencePersistenceBackends.keySet()) {
            AccountingPersistenceBackend apb = persistencePersistenceBackends.get(scope);
            try {
                logger.debug("Flushing records in scope {}", (Object)scope);
                apb.flush(timeout, timeUnit);
            }
            catch (Exception e) {
                logger.error("Unable to flush records in scope {} with {}", (Object)scope, (Object)apb);
            }
        }
    }

    static {
        persistencePersistenceBackends = new HashMap<String, AccountingPersistenceBackend>();
    }
}

