/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.BannedService;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-validation")
public class RequestValidator
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext context;

    @Override
    public void handleRequest(RequestEvent call) {
        this.context = (ApplicationContext)call.context();
        this.validateAgainstLifecycle(call);
        if (!this.validateToken(call)) {
            String scope = call.request().getHeader("gcube-scope");
            this.validateScope(scope);
            log.info("received call to {} in scope {}", (Object)call.uri(), (Object)scope);
        }
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.context.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScope(String scope) {
        if (scope == null) {
            log.info("rejecting unscoped call to {}", (Object)this.context.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        if (!this.context.profile(GCoreEndpoint.class).scopes().contains((Object)scope)) {
            log.info("rejecting call to {} in invalid scope {}", (Object)this.context.name(), (Object)scope);
            RequestError.invalid_request_error.fire(this.context.name() + " cannot be called in scope " + scope);
        }
        ScopeProvider.instance.set(scope);
    }

    private boolean validateToken(RequestEvent call) {
        String token;
        String string = token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        if (token == null && call.request().getHeader("gcube-scope") == null) {
            if (call.request().getHeader("Authorization") != null) {
                String basicAuthorization = call.request().getHeader("Authorization");
                String base64Credentials = basicAuthorization.substring("Basic".length()).trim();
                String credentials = new String(DatatypeConverter.parseBase64Binary((String)base64Credentials));
                String[] values = credentials.split(":", 2);
                token = values[1];
                UserInfo info = this.retreiveAndSetInfo(token, call);
                if (!info.getUserName().equals(values[0])) {
                    log.info("rejecting call to {}, username {} not valid for token {}", new Object[]{this.context.name(), values[0], token});
                    RequestError.request_not_authorized_error.fire(this.context.name() + ": username " + values[0] + " not valid for token " + token);
                }
                return true;
            }
            log.info("rejecting call to {}, authorization required", (Object)this.context.name(), (Object)token);
            RequestError.request_not_authorized_error.fire(this.context.name() + ": authorization required");
        }
        log.trace("token is " + token);
        if (token != null) {
            this.retreiveAndSetInfo(token, call);
            return true;
        }
        log.info("invalid token, returning false");
        return false;
    }

    @Override
    public String toString() {
        return "request-validation";
    }

    private UserInfo retreiveAndSetInfo(String token, RequestEvent call) {
        ScopeProvider.instance.set("/" + ((ApplicationContext)call.context()).container().configuration().infrastructure());
        AuthorizationEntry authEntry = null;
        try {
            authEntry = ((AuthorizationProxy)Constants.authorizationService().build()).get(token);
        }
        catch (ObjectNotFound onf) {
            log.warn("rejecting call to {}, invalid token {}", (Object)this.context.name(), (Object)token);
            RequestError.invalid_request_error.fire(this.context.name() + " invalid token : " + token);
        }
        catch (Exception e) {
            log.error("error contacting authorization service", (Throwable)e);
            RequestError.internal_server_error.fire("error contacting authorization service");
        }
        if (authEntry.getBannedServices().contains(new BannedService(((ApplicationContext)call.context()).configuration().serviceClass(), ((ApplicationContext)call.context()).configuration().name()))) {
            log.error("rejecting call to {}, invalid token {}: service is banned for this token", (Object)this.context.name(), (Object)token);
            RequestError.invalid_request_error.fire("rejecting call to " + this.context.name() + ", invalid token " + token + ": service is banned for this token");
        }
        UserInfo info = new UserInfo(authEntry.getUserName(), authEntry.getRoles(), authEntry.getBannedServices());
        AuthorizationProvider.instance.set(info);
        this.validateScope(authEntry.getScope());
        log.info("retrieved request authorization info " + AuthorizationProvider.instance.get() + " in scope " + ScopeProvider.instance.get());
        SecurityTokenProvider.instance.set(token);
        return info;
    }
}

