/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gcube.common.scan.resources.ClasspathResource;

public class FileResource
implements ClasspathResource {
    private final String relativePath;
    private final String rootPath;

    public FileResource(String absolutePath, String relativePath) {
        this.relativePath = relativePath;
        this.rootPath = absolutePath;
    }

    @Override
    public String name() {
        return this.relativePath.substring(this.relativePath.lastIndexOf(File.separatorChar) + 1);
    }

    @Override
    public String path() {
        String path = this.relativePath;
        if (this.relativePath.endsWith(".class")) {
            path = this.relativePath.replace("/", ".");
        }
        return path;
    }

    @Override
    public InputStream stream() {
        try {
            return new FileInputStream(this.file());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("cannot read resource after existence check", e);
        }
    }

    @Override
    public File file() {
        return new File(this.rootPath, this.relativePath);
    }

    public String toString() {
        return "file-entry:" + this.path();
    }
}

