/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.utils.sweeper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.AdvancedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweeper {
    String ghn_state_path = "";
    Logger logger = LoggerFactory.getLogger(Sweeper.class);

    public Sweeper() throws Exception {
        String ghn_path = System.getenv("GHN_HOME");
        if (ghn_path == null) {
            this.logger.error("GHN_HOME not defined");
            throw new Exception("GHN_HOME not defined");
        }
        this.ghn_state_path = ghn_path + File.separator + "state";
    }

    public HostingNode getGHNProfile() throws JAXBException, FileNotFoundException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{HostingNode.class});
        Unmarshaller um = jc.createUnmarshaller();
        HostingNode hostingNode = (HostingNode)um.unmarshal((InputStream)new FileInputStream(this.ghn_state_path + File.separator + "ghn.xml"));
        return hostingNode;
    }

    public GCoreEndpoint getRunningInstanceProfile(String name) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{GCoreEndpoint.class});
        Unmarshaller um = jc.createUnmarshaller();
        GCoreEndpoint ri = null;
        File subfolder = new File(this.ghn_state_path + File.separator + name);
        try {
            ri = (GCoreEndpoint)um.unmarshal((InputStream)new FileInputStream(subfolder.getAbsolutePath() + File.separator + "endpoint.xml"));
        }
        catch (FileNotFoundException | JAXBException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return ri;
    }

    public ArrayList<GCoreEndpoint> getRunningInstanceProfiles() throws Exception {
        String[] files;
        ArrayList<GCoreEndpoint> endpoints = new ArrayList<GCoreEndpoint>();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{GCoreEndpoint.class});
        Unmarshaller um = jc.createUnmarshaller();
        File file = new File(this.ghn_state_path);
        for (String name : files = file.list()) {
            GCoreEndpoint ri;
            File subfolder = new File(this.ghn_state_path + File.separator + name);
            if (!subfolder.isDirectory()) continue;
            try {
                ri = (GCoreEndpoint)um.unmarshal((InputStream)new FileInputStream(subfolder.getAbsolutePath() + File.separator + "endpoint.xml"));
            }
            catch (FileNotFoundException | JAXBException e) {
                e.printStackTrace();
                continue;
            }
            endpoints.add(ri);
        }
        return endpoints;
    }

    public void cleanGHNProfile() throws Exception {
        this.forceDeleteResource((Resource)this.getGHNProfile());
    }

    public void cleanRIProfile(String name) throws Exception {
        this.forceDeleteResource((Resource)this.getRunningInstanceProfile(name));
    }

    public void cleanRIProfiles() throws Exception {
        for (GCoreEndpoint endp : this.getRunningInstanceProfiles()) {
            this.forceDeleteResource((Resource)endp);
        }
    }

    private void forceDeleteResource(Resource resource) {
        ScopeBean scope = new ScopeBean((String)resource.scopes().iterator().next());
        while (!scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
            scope = scope.enclosingScope();
        }
        ScopeProvider.instance.set(scope.toString());
        RegistryPublisher rp = RegistryPublisherFactory.create();
        AdvancedPublisher advancedPublisher = new AdvancedPublisher(rp);
        advancedPublisher.forceRemove(resource);
        this.logger.debug("Correctly Removed resource " + resource.id());
    }
}

