/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.provider;

import java.lang.reflect.Method;
import java.util.List;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;

public class OfflinePublisher
implements ScopedPublisher {
    public <T extends Resource> T create(T resource, List<String> scopes) throws RegistryNotFoundException {
        for (String scope : scopes) {
            try {
                Method m = resource.getClass().getSuperclass().getDeclaredMethod("addScope", String.class);
                m.setAccessible(true);
                m.invoke(resource, scope);
            }
            catch (Exception e) {
                throw new RuntimeException("could not simulate publication in scope " + scope, e);
            }
        }
        return resource;
    }

    public <T extends Resource> T remove(T resource, List<String> scopes) throws RegistryNotFoundException {
        for (String scope : scopes) {
            try {
                Method m = resource.getClass().getSuperclass().getDeclaredMethod("removeScope", String.class);
                m.setAccessible(true);
                m.invoke(resource, scope);
            }
            catch (Exception e) {
                throw new RuntimeException("could not simulate publication remove from scope " + scope, e);
            }
        }
        return resource;
    }

    public <T extends Resource> T update(T resource) throws RegistryNotFoundException {
        return resource;
    }
}

