/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears;

import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.managers.ApplicationManager;
import org.gcube.smartgears.managers.ContainerManager;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
implements ServletContainerInitializer {
    private static Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private boolean containerHasFailed = false;
    private ContainerManager manager;
    private ContainerContext context;

    public void onStartup(Set<Class<?>> c, ServletContext application) throws ServletException {
        ApplicationManager appManager = new ApplicationManager();
        if (Utils.isResource(application)) {
            try {
                this.initialiseContainerIfStillNeeded(application);
                log.info("starting management of application @ {}", (Object)application.getContextPath());
                ApplicationContext app = appManager.start(this.context, application);
                this.manager.manage(app);
            }
            catch (Throwable t) {
                appManager.stop();
                throw new ServletException("cannot manage application @ " + application.getContextPath() + " (see cause)", t);
            }
        }
    }

    private void initialiseContainerIfStillNeeded(ServletContext application) {
        boolean containerIsNotInitialised = this.context == null && !this.containerHasFailed;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        if (containerIsNotInitialised) {
            try {
                Thread.currentThread().setContextClassLoader(ContainerManager.class.getClassLoader());
                this.manager = ContainerManager.instance;
                this.context = this.manager.start();
            }
            catch (RuntimeException e) {
                this.containerHasFailed = true;
                throw new IllegalStateException("container is not managed", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        } else if (this.containerHasFailed) {
            throw new IllegalStateException("container is not managed");
        }
    }
}

