/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.io.File;
import java.util.Set;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.configuration.application.Include;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.persistence.LocalPersistence;
import org.gcube.smartgears.persistence.PersistenceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgedApplicationConfiguration
implements ApplicationConfiguration {
    private static Logger log = LoggerFactory.getLogger(ApplicationConfiguration.class);
    private final ApplicationConfiguration application;

    public BridgedApplicationConfiguration(ContainerConfiguration container, ApplicationConfiguration config) {
        this.application = config;
        if (this.application.persistence() == null) {
            String location = container.persistence().getLocation() + "/" + this.application.name();
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.application.persistence(new LocalPersistence(location));
            log.trace("setting persistence location for {} @ {}", (Object)this.application.name(), (Object)dir.getAbsolutePath());
        }
        if (this.application.proxable() && container.proxy() != null) {
            this.application.proxyAddress(container.proxy());
        }
    }

    public ApplicationConfiguration inner() {
        return this.application;
    }

    @Override
    public String context() {
        return this.application.context();
    }

    @Override
    public ApplicationConfiguration context(String context) {
        return this.application.context(context);
    }

    @Override
    public String name() {
        return this.application.name();
    }

    @Override
    public ApplicationConfiguration name(String name) {
        return this.application.name(name);
    }

    @Override
    public String serviceClass() {
        return this.application.serviceClass();
    }

    @Override
    public ApplicationConfiguration serviceClass(String group) {
        return this.application.serviceClass(group);
    }

    @Override
    public String version() {
        return this.application.version();
    }

    @Override
    public ApplicationConfiguration version(String version) {
        return this.application.version(version);
    }

    @Override
    public String description() {
        return this.application.description();
    }

    @Override
    public ApplicationConfiguration description(String description) {
        return this.application.description(description);
    }

    @Override
    public PersistenceWriter persistence() {
        return this.application.persistence();
    }

    @Override
    public ApplicationConfiguration persistence(PersistenceWriter manager) {
        return this.application.persistence(manager);
    }

    @Override
    public void validate() {
        this.application.validate();
    }

    @Override
    public Set<Exclude> excludes() {
        return this.application.excludes();
    }

    @Override
    public Set<Include> includes() {
        return this.application.includes();
    }

    @Override
    public void merge(ApplicationConfiguration config) {
        this.application.merge(config);
    }

    @Override
    public boolean proxable() {
        return this.application.proxable();
    }

    @Override
    public ApplicationConfiguration excludes(Exclude ... excludes) {
        return this.application.excludes(excludes);
    }

    @Override
    public ApplicationConfiguration includes(Include ... includes) {
        return this.application.includes(includes);
    }

    @Override
    public ProxyAddress proxyAddress() {
        return this.application.proxyAddress();
    }

    @Override
    public ApplicationConfiguration proxyAddress(ProxyAddress proxy) {
        return this.proxyAddress(proxy);
    }
}

