/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.GCubeJWTObject;
import org.gcube.common.security.secrets.Secret;

public class AccessTokenSecret
extends Secret {
    private String encodedAccessToken;
    private Owner owner;
    private String context;
    private AccessToken accessToken;
    private boolean initialised = false;

    public AccessTokenSecret(String encodedAccessToken) {
        this.encodedAccessToken = encodedAccessToken;
    }

    public Owner getOwner() {
        this.init();
        return this.owner;
    }

    public String getContext() {
        this.init();
        return this.context;
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("Authorization", "Bearer " + this.encodedAccessToken);
        return authorizationHeaders;
    }

    protected String getEncodedAccessToken() {
        return this.encodedAccessToken;
    }

    public boolean isExpired() {
        this.init();
        return this.accessToken.isExpired();
    }

    public boolean isRefreshable() {
        return false;
    }

    private synchronized void init() {
        if (!this.initialised) {
            try {
                String realAccessTokenEncoded = this.encodedAccessToken.split("\\.")[1];
                String decodedAccessPart = new String(Base64.getDecoder().decode(realAccessTokenEncoded.getBytes()));
                ObjectMapper objectMapper = new ObjectMapper();
                GCubeJWTObject obj = (GCubeJWTObject)objectMapper.readValue(decodedAccessPart, GCubeJWTObject.class);
                this.owner = new Owner(obj.getUsername(), obj.getRoles(), obj.getEmail(), obj.getFirstName(), obj.getLastName(), obj.isExternalService());
                this.owner.setClientName(obj.getClientName());
                this.owner.setContactOrganisation(obj.getContactOrganisation());
                this.owner.setClientName(obj.getClientName());
                this.context = obj.getContext();
                this.accessToken = (AccessToken)objectMapper.readValue(decodedAccessPart, AccessToken.class);
                this.initialised = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

