/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProfileManager
extends ApplicationLifecycleHandler {
    Logger log = LoggerFactory.getLogger(ApplicationProfileManager.class);
    private ApplicationContext context;
    private ScheduledFuture<?> periodicUpdates;
    private static final String PUBLISHED_PROP = "published";
    private List<Publisher> publishers = ProviderFactory.provider().publishers();

    @Override
    public void onStart(ApplicationLifecycleEvent.Start e) {
        this.context = (ApplicationContext)e.context();
        this.activated();
    }

    private void activated() {
        this.publishers = this.context.container().configuration().mode() != Mode.offline ? ProviderFactory.provider().publishers() : Collections.emptyList();
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                ApplicationProfileManager.this.log.debug("moving app {} to {}", (Object)ApplicationProfileManager.this.context.name(), (Object)((ApplicationState)lc.state()).remoteForm());
                ApplicationProfileManager.this.context.events().fire((Object)ApplicationProfileManager.this.context, new String[]{"changed"});
            }

            @Observes(value={"changed"}, kind=Observes.Kind.safe)
            void publishAfterChange(ApplicationContext context) {
                if (!context.properties().contains(ApplicationProfileManager.PUBLISHED_PROP)) {
                    ApplicationProfileManager.this.log.info("publishing application for the first time");
                    context.properties().add(new Property(ApplicationProfileManager.PUBLISHED_PROP, true));
                    if (context.lifecycle().state() != ApplicationState.failed) {
                        ApplicationProfileManager.this.publishers.forEach(p -> {
                            try {
                                p.create(context, context.container().configuration().authorizationProvider().getContexts());
                            }
                            catch (Exception e) {
                                ApplicationProfileManager.this.log.error("cannot publish {} for first time with publisher type {} (see details)", new Object[]{context.name(), p.getClass().getCanonicalName(), e});
                            }
                        });
                    }
                } else {
                    ApplicationProfileManager.this.publishers.forEach(p -> {
                        try {
                            p.update(context);
                        }
                        catch (Exception e) {
                            ApplicationProfileManager.this.log.error("cannot publish {} with publisher type {} (see details)", new Object[]{context.name(), p.getClass().getCanonicalName(), e});
                        }
                    });
                }
            }
        });
        this.context.container().events().subscribe(new Object(){

            @Observes(value={"addToContext"})
            void addTo(String scope) {
                ApplicationProfileManager.this.log.info("add_to_context event arrived in app {}", (Object)ApplicationProfileManager.this.context.name());
                for (Publisher publisher : ApplicationProfileManager.this.publishers) {
                    try {
                        ApplicationProfileManager.this.log.debug("publishing application in context {}", (Object)scope);
                        publisher.create(ApplicationProfileManager.this.context, Collections.singleton(scope));
                    }
                    catch (Exception e) {
                        ApplicationProfileManager.this.log.error("cannot add context {} with publisher type {} (see details)", new Object[]{scope, publisher.getClass().getCanonicalName(), e});
                    }
                }
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String scope) {
                ApplicationProfileManager.this.log.info("remove_from_context event arrived in app {}", (Object)ApplicationProfileManager.this.context.name());
                for (Publisher publisher : ApplicationProfileManager.this.publishers) {
                    try {
                        ApplicationProfileManager.this.log.debug("unpublishing application from scope {}", (Object)scope);
                        publisher.remove(ApplicationProfileManager.this.context, Collections.singleton(scope));
                    }
                    catch (Exception e) {
                        ApplicationProfileManager.this.log.error("cannot remove scope {} with publisher type {} (see details)", new Object[]{scope, publisher.getClass().getCanonicalName(), e});
                    }
                }
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ApplicationLifecycle lc) {
                if (ApplicationProfileManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    ApplicationProfileManager.this.log.info("scheduling periodic updates of application {} profile", (Object)ApplicationProfileManager.this.context.name());
                } else {
                    ApplicationProfileManager.this.log.info("resuming periodic updates of application {} profile", (Object)ApplicationProfileManager.this.context.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationProfileManager.this.log.trace("firing change event on application {} ", (Object)ApplicationProfileManager.this.context.name());
                        ApplicationProfileManager.this.context.events().fire((Object)ApplicationProfileManager.this.context, new String[]{"changed"});
                    }
                };
                ApplicationProfileManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (ApplicationProfileManager.this.periodicUpdates != null) {
                    ApplicationProfileManager.this.log.trace("stopping periodic updates of application {} profile", (Object)ApplicationProfileManager.this.context.name());
                    try {
                        ApplicationProfileManager.this.periodicUpdates.cancel(true);
                        ApplicationProfileManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        ApplicationProfileManager.this.log.warn("could not stop periodic updates of application {}", (Object)ApplicationProfileManager.this.context.name(), (Object)e);
                    }
                }
            }
        });
    }

    @Override
    public String toString() {
        return "profile-management";
    }
}

