/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.gcube.common.events.Hub;
import org.gcube.common.events.impl.DefaultHub;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfigurationBinder;
import org.gcube.smartgears.configuration.application.ApplicationExtensions;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.configuration.application.BridgedApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfigurationBinder;
import org.gcube.smartgears.configuration.library.SmartGearsConfiguration;
import org.gcube.smartgears.configuration.library.SmartGearsConfigurationBinder;
import org.gcube.smartgears.context.Properties;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.context.container.DefaultContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.Provider;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.gcube.smartgears.security.AuthorizationProvider;
import org.gcube.smartgears.utils.Utils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProvider
implements Provider {
    private static Logger log = LoggerFactory.getLogger(Provider.class);
    private ContainerContext containerContext;
    private File configFile = null;
    List<Publisher> publishers;

    protected DefaultProvider(File configFile) {
        this.configFile = configFile;
    }

    protected DefaultProvider() {
    }

    @Override
    public ContainerContext containerContext() {
        if (this.containerContext == null) {
            ContainerConfiguration configuration = this.containerConfiguration();
            DefaultHub hub = new DefaultHub();
            ContainerLifecycle lifecycle = new ContainerLifecycle((Hub)hub);
            File file = configuration.persistence().file("ghn.xml");
            String id = null;
            if (file.exists()) {
                log.info("loading persisted state for container");
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                    id = (String)ois.readObject();
                }
                catch (Exception e) {
                    log.error("error loading persisted state, creating new uuid", (Throwable)e);
                }
            }
            if (id == null) {
                id = UUID.randomUUID().toString();
                log.info("container id created is {}", (Object)id);
            }
            this.containerContext = new DefaultContainerContext(id, configuration, (Hub)hub, lifecycle, new Properties());
        }
        return this.containerContext;
    }

    @Override
    public List<ContainerHandler> containerHandlers() {
        try {
            ContainerConfigurationBinder binder = new ContainerConfigurationBinder();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader.getParent() != null && !currentClassLoader.getParent().equals(ClassLoader.getSystemClassLoader())) {
                log.trace("probably i'm in a webapp classloader");
                currentClassLoader = currentClassLoader.getParent();
            }
            List<ContainerHandler> defaultHandlers = binder.bindHandlers(currentClassLoader);
            return defaultHandlers;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install container handlers (see cause) ", e);
        }
    }

    @Override
    public ApplicationContext contextFor(ContainerContext context, ServletContext application) {
        ApplicationConfiguration configuration = null;
        ApplicationConfiguration embedded = this.configurationFor(application);
        ApplicationConfiguration external = context.configuration().app(application.getContextPath());
        if (embedded == null && external == null) {
            throw new AssertionError((Object)("application @ " + application.getContextPath() + " is not distributed with " + "/WEB-INF/gcube-app.xml" + " and there is no external configuration for it in " + "container.ini"));
        }
        if (embedded == null) {
            configuration = external;
            log.info("loaded  configuration for application " + configuration.name() + " from " + "container.ini");
        } else {
            configuration = embedded;
            if (external == null) {
                log.info("loaded configuration for application " + configuration.name() + " from " + "/WEB-INF/gcube-app.xml");
            } else {
                configuration.merge(external);
                log.info("loaded configuration for application " + configuration.name() + " from " + "/WEB-INF/gcube-app.xml" + " and " + "container.ini");
            }
        }
        BridgedApplicationConfiguration bridgedConfiguration = new BridgedApplicationConfiguration(context.configuration(), configuration);
        DefaultHub hub = new DefaultHub();
        ApplicationLifecycle lifecycle = new ApplicationLifecycle((Hub)hub, configuration.name());
        File file = bridgedConfiguration.persistence().file("endpoint.xml");
        String id = null;
        if (file.exists()) {
            log.info("loading persisted state for application {}", (Object)application.getContextPath());
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                id = (String)ois.readObject();
            }
            catch (Exception e) {
                log.error("error loading persisted state, creating new uuid", (Throwable)e);
            }
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        return new DefaultApplicationContext(id, context, application, bridgedConfiguration, (Hub)hub, lifecycle, new Properties());
    }

    @Override
    public ApplicationHandlers handlersFor(ApplicationContext context) {
        try {
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader.getParent() != null && !currentClassLoader.getParent().equals(ClassLoader.getSystemClassLoader())) {
                log.trace("probably i'm in a webapp classloader");
                currentClassLoader = currentClassLoader.getParent();
            }
            ApplicationHandlers defaultHandlers = binder.bindHandlers(currentClassLoader);
            return defaultHandlers;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install handlers for application @ " + context.name() + " (see cause) ", e);
        }
    }

    @Override
    public ApplicationExtensions extensionsFor(ApplicationContext context) {
        try {
            InputStream config = context.application().getResourceAsStream("/WEB-INF/gcube-extensions.xml");
            if (config == null) {
                log.trace("{} uses default extensions as it does not include {}", (Object)context.name(), (Object)"/WEB-INF/gcube-extensions.xml");
                config = this.getClass().getResourceAsStream("/META-INF/default-extensions.xml");
                if (config == null) {
                    throw new IllegalStateException("invalid distribution: cannot find /META-INF/default-extensions.xml");
                }
            } else {
                log.info("{} uses custom extensions @ {}", (Object)context.name(), (Object)"/WEB-INF/gcube-extensions.xml");
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.bindExtensions(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install extensions for application @ " + context.name() + " (see cause) ", e);
        }
    }

    @Override
    public SmartGearsConfiguration smartgearsConfiguration() {
        try {
            InputStream config = this.getClass().getResourceAsStream("/META-INF/smartgears-config.xml");
            if (config == null) {
                throw new IllegalStateException("invalid distribution: cannot find /META-INF/smartgears-config.xml");
            }
            SmartGearsConfigurationBinder binder = new SmartGearsConfigurationBinder();
            SmartGearsConfiguration configuration = binder.bind(config);
            configuration.validate();
            return configuration;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot read library configuration (see cause) ", e);
        }
    }

    private ApplicationConfiguration configurationFor(ServletContext application) {
        try {
            InputStream config = application.getResourceAsStream("/WEB-INF/gcube-app.xml");
            if (config == null) {
                return null;
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.bind(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("invalid configuration (see cause)", e);
        }
    }

    private ContainerConfiguration containerConfiguration() {
        ContainerConfiguration configuration;
        if (this.configFile == null) {
            String home = Utils.home();
            if (home == null) {
                throw new IllegalStateException("invalid node configuration: the environment variable GHN_HOME or the system property ghn.home must be defined");
            }
            File homeDir = new File(home);
            if (!(homeDir.exists() && homeDir.isDirectory() && homeDir.canRead() && homeDir.canWrite())) {
                throw new IllegalStateException("invalid node configuration: home " + home + " does not exist or is not a directory or cannot be accessed in read/write mode");
            }
            this.configFile = new File(homeDir, "container.ini");
            log.trace("reading container configuration @ {} ", (Object)this.configFile.getAbsolutePath());
        }
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            throw new IllegalStateException("invalid node configuration: file " + this.configFile.getAbsolutePath() + " does not exist or cannot be accessed");
        }
        try (FileInputStream stream = new FileInputStream(this.configFile);){
            configuration = new ContainerConfigurationBinder().load(stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid node configuration: file " + this.configFile.getAbsolutePath() + " is invalid", e);
        }
        return configuration;
    }

    @Override
    public synchronized List<Publisher> publishers() {
        if (this.publishers == null) {
            Collection urls = ClasspathHelper.forClassLoader((ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()});
            urls.removeIf(url -> url.toString().endsWith(".so") || url.toString().endsWith(".zip"));
            ConfigurationBuilder reflectionConf = new ConfigurationBuilder().addUrls(urls).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
            Reflections reflection = new Reflections((Configuration)reflectionConf);
            Set annotatedPublishers = reflection.getTypesAnnotatedWith(SmartgearsProfilePublisher.class);
            ArrayList<Publisher> foundPublishers = new ArrayList<Publisher>();
            for (Class annotatedPublisher : annotatedPublishers) {
                if (Publisher.class.isAssignableFrom(annotatedPublisher)) {
                    try {
                        foundPublishers.add((Publisher)annotatedPublisher.newInstance());
                        log.info("added class {} to publishers", (Object)annotatedPublisher);
                    }
                    catch (Exception e) {
                        log.error("publisher class {} cannot be instantiated", (Object)annotatedPublisher.getCanonicalName(), (Object)e);
                    }
                    continue;
                }
                log.warn("publisher class {} discarded, it doesn't implements Publisher class", (Object)annotatedPublisher.getCanonicalName());
            }
            this.publishers = foundPublishers;
            if (foundPublishers.isEmpty()) {
                log.warn("no publishers found in classloader");
            }
        }
        return this.publishers;
    }

    @Override
    public AuthorizationProvider authorizationProvider() {
        return this.containerContext.configuration().authorizationProvider();
    }
}

